//===========================================================================
//
// Module:		LNDOC.HPP
//
// Description:	Class library definition for the LNDocument class.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNDOC_HPP
#define LNDOC_HPP

enum LNMAILMSGTYPE
{
	LNMAILMSGTYPE_FORWARD,					//Forward message
	LNMAILMSGTYPE_REPLY,					//Reply message
	LNMAILMSGTYPE_REPLY_WITH_HISTORY,		//Reply message with history
	LNMAILMSGTYPE_REPLY_TO_ALL,				//Reply To All message
	LNMAILMSGTYPE_REPLY_TO_ALL_WITH_HISTORY,//Reply To All with history
	LNMAILMSGTYPE_MEMO						//Regular message
};

//
//	Class definition for LNDocument.
//
class LNDocument : public LNNote
{
friend class LNDatabase;
friend class LNDatabaseBody;
friend class LNDocumentArray;
friend class LNVFEntryBody;
friend class LNDocumentBody;
friend class LNMailMessage;

public:
	LNDocument();
	LNDocument( const LNDocument &other );
	LNDocument( const LNNote &other, LNINT score = 0 );

	~LNDocument();

	LNDocument & operator=( const LNDocument &other );
	LNDocument & operator=( const LNNote &other );

	LNCLASSID GetClassID() const {return LNCLASSID_LNDOCUMENT;}

	LNSTATUS Close();

	LNSTATUS GetAllResponses( LNDocumentArray *responses );

	LNText GetCategories();

	LNSTATUS GetForm( LNString *form )
		{return GetFormNote(form);}
	LNSTATUS GetForm( LNForm *form )
		{return GetFormNote(form);}

	LNSTATUS GetParentDocument( LNDocument *parent );

	LNINT	 GetResponseCount();

	LNSTATUS GetResponses( LNDocumentArray *responses );

	LNINT GetFTSearchScore() const;

	LNBOOL IsResponse();

	LNSTATUS MakeResponse( const LNDocument &parent );

	LNSTATUS Open( LNNOTEOPENFLAGS options=LNNOTEOPENFLAGS_DEFAULT);

	LNSTATUS SetForm(const LNString &formname);
	LNSTATUS SetForm(const LNText &formname);

private:
	LNDocument( LNDatabaseBody *db, NOTEID idnote, LNINT score = 0 );

	LNDocument & operator=( LNDocumentBody *doc );

	LNSTATUS CreateDocumentBody();
	LNDocumentBody* GetDocumentBody() const { return(LNDocumentBody*)Body; }

	LNSTATUS GetFormNote( LNString *formname );
	LNSTATUS GetFormNote( LNForm *form );

	LNINT FTSearchScore;
};


#endif	//LNDOC_HPP

