//===========================================================================
//
// Module:		LNDATE.HPP
//
// Description:	Class library definitions for date and time related classes.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNDATE_HPP
#define LNDATE_HPP

#ifndef LNGLOBAL_H
#include "lnglobal.h"
#endif


const BYTE MAX_DECIMAL_DIGITS = 16;		// allows any number up to 15

//
//	Class definition for LNInternational.
//
class LNInternational : public LNNotesClass
{
friend class LNDatetime;
friend class LNDatetimeRange;
friend class LNNumber;
friend class LNNotesSession;

public:
	LNInternational();
	LNInternational( const LNInternational &other );

	~LNInternational();

	LNInternational & operator=( const LNInternational &other );

	LNString GetAMString() const;

	virtual LNCLASSID GetClassID() const {return LNCLASSID_LNINTERNATIONAL;}

	LNINT GetCurrencyDigits() const;

	LNBOOL GetCurrencySpace() const;

	LNString GetCurrencySymbol() const;

	LNBOOL GetCurrencySymbolSuffix() const;

	LNDATEORDER GetDateOrder() const;

	LNString GetDateSeparator() const;

	LNString GetDecimalSeparator() const;

	LNBOOL GetDSTObserved() const;

	LNBOOL GetLeadingZero() const;

	LNString GetPMString() const;

	LNString GetThousandSeparator() const;

	LNBOOL Get24HourFormat() const;

	LNString GetTimeSeparator() const;

	LNTIMEZONE GetTimeZone() const;

	LNString GetTodayString() const;

	LNString GetTomorrowString() const;

	LNString GetYesterdayString() const;

	LNSTATUS SetAMString( const LNString &amstring );

	LNSTATUS SetCurrencyDigits( LNINT digits );

	void SetCurrencySpace( LNBOOL currspace );

	LNSTATUS SetCurrencySymbol( const LNString &currencystring );

	void SetCurrencySymbolSuffix( LNBOOL currplace );

	LNSTATUS SetDateOrder( LNDATEORDER dateorder );

	LNSTATUS SetDateSeparator( const LNString &datesep );

	LNSTATUS SetDecimalSeparator( const LNString &decimalsep );

	void SetDSTObserved( LNBOOL daylight );

	void SetLeadingZero( LNBOOL leadzero );

	LNSTATUS SetPMString( const LNString &pmstring );

	LNSTATUS SetThousandSeparator( const LNString &thousandsep );

	void Set24HourFormat( LNBOOL format );

	LNSTATUS SetTimeSeparator( const LNString &timesep );

	LNSTATUS SetTimeZone( LNTIMEZONE timezone );

	LNSTATUS SetTodayString( const LNString &todaystring );

	LNSTATUS SetTomorrowString( const LNString &tomorrowstring );

	LNSTATUS SetYesterdayString( const LNString &yesterdaystring );

private:
	LNInternational( const LNNotesSession *session, INTLFORMAT *intlformat );

	INTLFORMAT * GetInternationalSettings();

	INTLFORMAT InternationalSettings;

};




// since TIMEDATE_MINIMUM is defined as 0 we need to do a specific case test for NOTACTIVE

enum LNDATETIMESPECIAL 
{
	LNDATETIME_MINIMUM = TIMEDATE_MINIMUM,
	LNDATETIME_MAXIMUM = TIMEDATE_MAXIMUM,
	LNDATETIME_WILDCARD = TIMEDATE_WILDCARD,
	LNDATETIME_NOTACTIVE
};

//
//	Class definition for LNDatetime.
//
class LNDatetime : public LNNotesClass
{
friend class LNDatetimeRange;
friend class LNDatetimeRanges;
friend class LNDatetimes;
friend class LNDatetimesElement;
friend class LNLogEntry;
friend class LNNotesSession;
friend class LNSearchOptions;
friend class LNVFFindKey;
friend class LNMailMessage;

public:
	LNDatetime();
	LNDatetime( const LNDatetime &other );
	LNDatetime( const LNString &datestring, LNSTATUS *lnerror=0 );
	LNDatetime( const LNDATETIMESPECIAL specialcase );

	~LNDatetime();

	LNDatetime & operator=( const LNDatetime &other );
	LNDatetime & operator=( const LNString &other );
	LNDatetime & operator=( const LNDATETIMESPECIAL specialcase );

	LNBOOL operator==( const LNDatetime &other ) const;

	LNBOOL operator!=( const LNDatetime &other ) const;

	LNBOOL operator<=( const LNDatetime &other ) const;

	LNBOOL operator>=( const LNDatetime &other ) const;

	LNBOOL operator<( const LNDatetime &other ) const;

	LNBOOL operator>( const LNDatetime &other ) const;
	operator LNString() const;

	LNSTATUS AdjustDay( LNSINT days );

	LNSTATUS AdjustHour( LNSINT hours );

	LNSTATUS AdjustHundredth( LNSINT hundredths );

	LNSTATUS AdjustMinute( LNSINT minutes );

	LNSTATUS AdjustMonth( LNSINT months );

	LNSTATUS AdjustSecond( LNSINT seconds );

	LNSTATUS AdjustTimeZone( LNTIMEZONE zone );

	LNSTATUS AdjustYear( LNSINT years );

	virtual LNCLASSID GetClassID() const {return LNCLASSID_LNDATETIME;}

	LNSTATUS GetDate( LNINT *month, LNINT *day, LNINT *year ) const;

	LNINT GetDay() const;

	LNDAYOFWEEK GetDayOfWeek() const;

	LNINT GetHour() const;

	LNINT GetHundredth() const;

	LNINT GetMinute() const;

	LNINT GetMonth() const;

	LNINT GetSecond() const;

	LNSTATUS GetText( LNString *text ) const;
	LNSTATUS GetText( const LNDatetimeFormat &fmt, const LNInternational &ifmt,
		LNString *text ) const;

	LNSTATUS GetTime( LNINT *hour, LNINT *minute, LNINT *second,
		LNINT *hundredth=0 ) const;

	LNTIMEZONE GetTimeZone() const;

	LNINT GetYear() const;

	LNBOOL IsDefined() const {return DateDefined;}

	LNBOOL IsSpecialCase() const {return (SpecialCase != 0);}

	LNBOOL IsDSTInEffect() const;

	LNSTATUS SetDate( LNINT month, LNINT day );
	LNSTATUS SetDate( LNINT month, LNINT day, LNINT year );

	LNSTATUS SetDay( LNINT day );

	LNSTATUS SetHour( LNINT hour );

	LNSTATUS SetHundredth( LNINT hundredth );

	LNSTATUS SetMinute( LNINT minute );

	LNSTATUS SetMonth( LNINT month );

	LNSTATUS SetSecond( LNINT second );

	LNSTATUS SetTime( LNINT hour, LNINT minute, LNINT second=0,
		LNINT hundredth=0 );

	LNSTATUS SetTimeZone( LNTIMEZONE timezone );

	LNSTATUS SetYear( LNINT year );

private:
	LNDatetime( const TIMEDATE *timedate );

	LNSTATUS GetText( LNString *text, LNDatetimeFormat *fmt,
		LNInternational *ifmt ) const;

	TIMEDATE * GetTIMEDATE() const;

	LNSTATUS SetDatetime( const TIMEDATE *datetime );

	TIME Datetime;
	LNBOOL DateDefined;
	WORD SpecialCase;
};

//
//	Class definition for LNDatetimeFormat.
//
class LNDatetimeFormat : public LNNotesClass
{
friend class LNDatetime;
friend class LNDatetimeRange;

public:
	LNDatetimeFormat();
	LNDatetimeFormat( const LNDatetimeFormat &other );

	~LNDatetimeFormat();

	LNDatetimeFormat & operator=( const LNDatetimeFormat &other );

	virtual LNCLASSID GetClassID() const {return LNCLASSID_LNDATETIMEFORMAT;}

	LNDATEFORMAT GetDateFormat() const
		{return (LNDATEFORMAT)DatetimeFormat.Date;}

	LNDATETIMEDISPLAY GetDatetimeDisplay() const
		{return (LNDATETIMEDISPLAY)DatetimeFormat.Structure;}

	LNTIMEFORMAT GetTimeFormat() const
		{return (LNTIMEFORMAT)DatetimeFormat.Time;}

	LNTIMEZONEDISPLAY GetTimeZoneDisplay() const
		{return (LNTIMEZONEDISPLAY)DatetimeFormat.Zone;}

	LNSTATUS SetDateFormat( LNDATEFORMAT format );

	LNSTATUS SetDatetimeDisplay( LNDATETIMEDISPLAY format );

	LNSTATUS SetTimeFormat( LNTIMEFORMAT format );

	LNSTATUS SetTimeZoneDisplay( LNTIMEZONEDISPLAY format );

private:
	TFMT * GetDatetimeFormat() {return &DatetimeFormat;}

	TFMT DatetimeFormat;
};

//
//	Class definition for LNDatetimeRange.
//
class LNDatetimeRange : public LNNotesClass
{
friend class LNDatetimeRanges;
friend class LNDatetimeRangesElement;

public:
	LNDatetimeRange();
	LNDatetimeRange( const LNDatetimeRange &other );
	LNDatetimeRange( const LNDatetime &datetime );

	~LNDatetimeRange();

	LNDatetimeRange & operator=( const LNDatetimeRange &other );
	LNDatetimeRange & operator=( const LNDatetime &datetime );

	virtual LNCLASSID GetClassID() const {return LNCLASSID_LNDATETIMERANGE;}

	LNDatetime GetBegin() const;

	LNDatetime GetEnd() const;

	LNSTATUS GetText( LNString *text ) const;
	LNSTATUS GetText( const LNDatetimeFormat &fmt, const LNInternational &ifmt,
		LNString *text ) const;

	LNBOOL IsBeginDefined() const;

	LNBOOL IsEndDefined() const;

	LNSTATUS SetBegin( const LNDatetime &begin );

	LNSTATUS SetEnd( const LNDatetime &end );

private:
	LNDatetimeRange( const TIMEDATE_PAIR *tdpair );
	LNDatetimeRange( const TIMEDATE *td );

	LNSTATUS GetText( LNString *text, LNDatetimeFormat *fmt,
		LNInternational *ifmt ) const;

	TIMEDATE_PAIR * GetTIMEDATEPAIR() const;

	TIMEDATE_PAIR DatetimeRange;
	LNBOOL BeginDateDefined;
	LNBOOL EndDateDefined;
};

#endif	//LNDATE_HPP

