//===========================================================================
//
// Module:		LNAGENT.HPP
//
// Description:	Class library definition for the LNAgent class.
//
//===========================================================================
//
// Copyright (c) 1996 Lotus Development Corporation. All rights reserved.
// This software is subject to the Lotus Software Agreement, Restricted
// Rights for U.S. government users, and applicable export regulations.
//
//===========================================================================

#ifndef LNAGENT_HPP
#define LNAGENT_HPP

#ifndef AGENT_DEFS
#include <agents.h>
#endif

//-----	Bit masks for the LNAgentBody Flags data member.

#define AGENTBODFLAG_NEWAGENT		0x0001	// 1 = agent note doesn't exist on disk
#define AGENTBODFLAG_AGENTOPEN		0x0002	// 1 = agent opened by LNAgentBody
#define AGENTBODFLAG_VALIDAGENT		0x0004	// 1 = note type has been validated


//----- enumeration of the Agent action types
enum LNAGENTACTIONTYPE
{
	LNAGENTACTION_UPDATE,	
	LNAGENTACTION_SELECT,	
	LNAGENTACTION_CREATE	
};


//----- enumeration of the type of documents that agent will act on:
enum LNAGENTDOCUMENTS
{
	LNAGENTDOCS_ALL,
	LNAGENTDOCS_UNREAD,
	LNAGENTDOCS_VIEW,
	LNAGENTDOCS_SELECTED_VIEW
};

//----- enumeration of the execution type of agent:
enum LNAGENTEXECTYPE
{
	LNAGENTEXEC_MENU,
	LNAGENTEXEC_BACKGROUND,
	LNAGENTEXEC_PASTMAIL,
	LNAGENTEXEC_EXECUTEONCE
};

//----- enumeration of the periodicity of agent:
enum LNAGENTFREQUENCY
{
	LNAGENTFREQ_HOURLY,
	LNAGENTFREQ_DAILY,
	LNAGENTFREQ_WEEKLY,
	LNAGENTFREQ_NEVER
};

//
//	Class definition for LNAgent.
//
class LNAgent : public LNNote
{
friend class LNDatabase;
friend class LNDatabaseBody;
friend class LNAgentArray;


public:
	LNAgent();
	LNAgent( const LNAgent &other );
	LNAgent( const LNNote &other );

	~LNAgent();

	LNAgent & operator=( const LNAgent &other );
	LNAgent & operator=( const LNNote &other );

	LNCLASSID GetClassID() const {return LNCLASS_LNAGENT;}

	LNSTATUS Close();
	LNSTATUS Execute();
	LNSTATUS Save();
	LNSTATUS Open();


private:
	LNAgent( LNDatabaseBody *db, NOTEID idnote );

	LNAgent & operator=( LNAgentBody *agentb );

	LNSTATUS CreateAgentBody();

	LNAgentBody * GetAgentBody() const { return (LNAgentBody *) Body; }
};


#endif	//LNAGENT_HPP

