#ifdef __cplusplus
extern "C" {
#endif

/*
	Public Definitions for Full Text Package
*/

#ifndef FT_DEFS
#define FT_DEFS

#ifndef NIF_DEFS
#include "nif.h"
#endif


/*	Define Indexing options */

#define FT_INDEX_REINDEX		0x0002		/* Re-index from scratch */
#define FT_INDEX_CASE_SENS		0x0004		/* Build case sensitive index */
#define FT_INDEX_STEM_INDEX		0x0008		/* Build stem index */
#define FT_INDEX_PSW			0x0010		/* Index paragraph & sentence breaks*/
#define FT_INDEX_OPTIMIZE		0x0020		/* Optimize index (e.g. for CDROM) */
#define FT_INDEX_ATT			0x0040		/* Index Attachments */
#define FT_INDEX_ENCRYPTED_FIELDS	0x0080		/* Index Encrypted Fields */
#define FT_INDEX_AUTOOPTIONS	0x0100		/* Get options from database */

/*	Define Search options */

#define FT_SEARCH_SET_COLL		0x00000001	/* Store search results in NIF collections;
												Don't return them to caller */
#define FT_SEARCH_NUMDOCS_ONLY	0x00000002	/* Return # hits only; not the documents */
#define FT_SEARCH_REFINE		0x00000004	/* Refine the query using the IDTABLE */
#define FT_SEARCH_SCORES		0x00000008	/* Return document scores (default sort) */
#define FT_SEARCH_RET_IDTABLE	0x00000010	/* Return ID table */
#define FT_SEARCH_SORT_DATE		0x00000020	/* Sort results by date */
#define FT_SEARCH_SORT_ASCEND	0x00000040	/* Sort in ascending order */
#define FT_SEARCH_TOP_SCORES	0x00000080	/* Use Limit arg. to return only top scores */
#define FT_SEARCH_STEM_WORDS	0x00000200	/* Stem words in this query */
#define FT_SEARCH_THESAURUS_WORDS	0x00000400	/* Thesaurus words in this query */

/*	Define search results data structure */

#define FT_RESULTS_SCORES		0x0001	/* Array of scores follows */

typedef struct
	{
	DWORD		NumHits;			/* Number of search hits following */
	WORD		Flags;				/* Flags (FT_RESULTS_xxx) */
	WORD		Spare;
									/* Followed by an array of NoteIDs */
									/* Followed by a BYTE array of scores 
										(optional) */
	}
FT_SEARCH_RESULTS;

typedef struct
	{
	DWORD		DocsAdded;			/* # of new documents */
	DWORD		DocsUpdated;		/* # of revised documents */
	DWORD		DocsDeleted;		/* # of deleted documents */
	DWORD		BytesIndexed;		/* # of bytes indexed */
	}
FT_INDEX_STATS;


/*	Function prototypes */

STATUS LNPUBLIC FTIndex(HANDLE hDB, WORD Options, 
						char far *StopFile, FT_INDEX_STATS far *retStats);
STATUS LNPUBLIC FTDeleteIndex(HANDLE hDB);
STATUS LNPUBLIC FTGetLastIndexTime(HANDLE hDB, TIMEDATE far *retTime);

STATUS LNPUBLIC FTOpenSearch(HANDLE far *rethSearch);
STATUS LNPUBLIC FTSearch(HANDLE hDB, HANDLE far *phSearch, HCOLLECTION hColl,
							char far *Query,
							DWORD Options, WORD Limit, HANDLE hIDTable,
							DWORD far *retNumDocs,
							HANDLE far *Reserved,
							HANDLE far *rethResults);
STATUS LNPUBLIC FTCloseSearch(HANDLE hSearch);


#endif	/* FT_DEFS */

#ifdef __cplusplus
}
#endif

