#ifdef __cplusplus
extern "C" {
#endif


/* Access Control List Package */

#ifndef ACL_DEFS
#define ACL_DEFS

/*	ACL-wide flags.  Get and set with ACLGetFlags and ACLSetFlags */

#define ACL_UNIFORM_ACCESS		0x00000001	/* Require same ACL in ALL replicas of database */

/* Access Levels  */

#define ACL_LEVEL_NOACCESS	0
#define ACL_LEVEL_DEPOSITOR	1
#define ACL_LEVEL_READER	2
#define ACL_LEVEL_AUTHOR	3
#define ACL_LEVEL_EDITOR	4
#define ACL_LEVEL_DESIGNER	5
#define ACL_LEVEL_MANAGER	6

#define ACL_LEVEL_HIGHEST	6			/* Highest access level */
#define ACL_LEVEL_COUNT		7			/* Number of access levels */


#define ACL_LEVEL_STRINGMAX	128			/* size to allocate for access descriptors */


/* Named privilege parameters */

#define ACL_PRIVCOUNT		80			/* Number of privilege bits (10 bytes) */
#define ACL_PRIVNAMEMAX		16			/* Privilege name max (including null) */
#define ACL_PRIVSTRINGMAX	16+2		/* Privilege string max */
										/* (including parentheses and null) */

#define ACL_BITPRIVCOUNT	5			/* Original "bit" privileges count */
#define ACL_BITPRIVS		0x1f		/* Original "bit" privileges mask */

#define ACL_BITPRIV_LEFT_PAREN '('		/* Original "bit" privilege name syntax */
#define ACL_BITPRIV_RIGHT_PAREN ')'		/* Original "bit" privilege name syntax */

#define ACL_SUBGROUP_LEFT_PAREN '['		/* Subgroup name syntax */
#define ACL_SUBGROUP_RIGHT_PAREN ']'	/* Subgroup name syntax */

/*  Access level modifier flags */

#define ACL_FLAG_AUTHOR_NOCREATE	0x0001	/* Authors can't create new notes 
												(only edit existing ones) */
#define ACL_FLAG_SERVER				0x0002	/* Entry represents a Server (V4) */
#define ACL_FLAG_NODELETE			0x0004	/* User cannot delete notes */

#define ACL_FLAG_CREATE_PRAGENT 	0x0008	/* User can create personal agents (V4) */
#define ACL_FLAG_CREATE_PRFOLDER	0x0010	/* User can create personal folders (V4) */
#define ACL_FLAG_PERSON				0x0020 	/* Entry represents a Person (V4) */
#define ACL_FLAG_GROUP				0x0040 	/* Entry represents a group (V4) */
#define ACL_FLAG_CREATE_FOLDER		0x0080	/* User can create and update shared views & folders (V4)
												This allows an Editor to assume some Designer-level access */
#define ACL_FLAG_CREATE_LOTUSSCRIPT	0x0100	/* User can create LotusScript */
#define ACL_FLAG_ADMIN_SERVER		0x8000	/* Entry is administration server (V4) */

/* ACLUpdateEntry flags - Set flag if parameter is being modified */

#define ACL_UPDATE_NAME 			0x01
#define ACL_UPDATE_LEVEL 			0x02
#define ACL_UPDATE_PRIVILEGES		0x04
#define ACL_UPDATE_FLAGS 			0x08


/* Usernames list structure */

typedef struct {
	WORD		NumNames;			/*  Number of names in list */
	LICENSEID 	Spare1;				/*  Unused - must be zero */
	BOOL		Spare2;				/*  Unused - must be zero */
									/*  Names follow as packed ASCIZ strings */
									/*  First name is Username. */
									/*  Subsequent names are ALL the group */
									/*	names that User is a member of */
									/*	(directly or indirectly). */
	} NAMES_LIST;

/* Privileges bitmap structure */

typedef struct {BYTE BitMask[10];} ACL_PRIVILEGES;

/* Privileges bitmap access */

#define ACLIsPrivSet(privs, num)	((privs).BitMask[num / 8] &   (1 << (num % 8)))
#define ACLSetPriv(privs, num)		((privs).BitMask[num / 8] |=  (1 << (num % 8)))
#define ACLClearPriv(privs, num)	((privs).BitMask[num / 8] &= ~(1 << (num % 8)))
#define ACLInvertPriv(privs, num)	((privs).BitMask[num / 8] ^=  (1 << (num % 8)))

/* Public Functions */

STATUS LNPUBLIC ACLLookupAccess (HANDLE hACL,
								NAMES_LIST far *pNamesList,
								WORD far *retAccessLevel,
								ACL_PRIVILEGES far *retPrivileges,
								WORD far *retAccessFlags,
								HANDLE far *rethPrivNames);
STATUS LNPUBLIC ACLCreate (HANDLE far *rethACL);
STATUS LNPUBLIC ACLAddEntry (HANDLE hACL,
								char far *Name,
								WORD AccessLevel,
								ACL_PRIVILEGES far *Privileges,
								WORD AccessFlags);
STATUS LNPUBLIC ACLDeleteEntry (HANDLE hACL,
								char far *Name);
STATUS LNPUBLIC ACLUpdateEntry (HANDLE hACL,
								char far *Name,
								WORD UpdateFlags,
								char far *NewName,
								WORD NewAccessLevel,
								ACL_PRIVILEGES far *NewPrivileges,
								WORD NewAccessFlags);
STATUS LNPUBLIC ACLEnumEntries (HANDLE hACL,
								void (LNCALLBACKPTR EnumFunc)(void far *EnumFuncParam,
														char far *Name,
														WORD AccessLevel,
														ACL_PRIVILEGES far *Privileges,
														WORD AccessFlags),
								void far *EnumFuncParam);
STATUS LNPUBLIC ACLGetPrivName (HANDLE hACL,
								WORD PrivNum,
								char far *retPrivName);
STATUS LNPUBLIC ACLSetPrivName (HANDLE hACL,
								WORD PrivNum,
								char far *PrivName);

STATUS LNPUBLIC ACLGetHistory (HANDLE hACL, HANDLE far *hHistory, WORD far *HistoryCount);
STATUS LNPUBLIC ACLGetFlags (HANDLE hACL, DWORD far *Flags);
STATUS LNPUBLIC ACLSetFlags (HANDLE hACL, DWORD Flags);
STATUS LNPUBLIC ACLGetAdminServer (HANDLE hList, char far *ServerName);
STATUS LNPUBLIC ACLSetAdminServer (HANDLE hList, char far *ServerName);

#endif

#ifdef __cplusplus
}
#endif

