/***********************************************************************
IE_EX1.C: Import/Export example program #1

Copyright (c) 1992-8 by Lotus Development Corporation, an IBM subsidiary.
All rights reserved.

This source code, any derivatives of it, and the resulting object code
may be freely used and/or copied, so long as this copyright notice is
included and remains unmodified.  Lotus Development Corporation does not
make any representation or warranty, express or implied with respect to
this source code.  Lotus Development Corporation disclaims any liability
whatsoever for any use of such code.

************************************************************************

    This program is an example of how to execute the Import or Export
    program from a C program.  It simply exports the headings of all
    the Inbox messages of the specified user to the specified file.
    The usage is:
        ie_ex1 name pswd drctry file

            where name is the user whose Inbox should be listed (enclose
                       in quotes if it contains spaces)
                  pswd is the user's password
                drctry is the directory where the post office is located.
                  file is the output file

    IE_EX1 returns an ERRORLEVEL of 0 for success and 1 for any error.

    EXPORT.EXE is assumed to be in the DOS PATH when this program is
    run.

    Build with Microsoft C version 5.1 or later using any memory model.
***********************************************************************/


// Include file(s)
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/***********************************************************************
IE_EX1 main routine (described above)
***********************************************************************/
int main(int argc, char *argv[])
{
    char filearg[_MAX_PATH + 2];
    int rtn;

    // Verify number of arguments
    if (argc != 5) {
        printf("Usage: ie_ex1 name pswd drctry file\n");
        return  1;
    }

    // Build the filename argument for EXPORT
    filearg[0] = '@';
    strcpy(filearg + 1, argv[4]);

    // Do it
    rtn = spawnlp(P_WAIT, "EXPORT.EXE", "EXPORT", argv[1], argv[2],
        argv[3], filearg, "NAME/1", "HEADINGS/ALL", NULL);

    // Handle errors and exit
    if (rtn == -1) {
        printf("ie_ex1: Cannot call the Export program; errno = %d\n",
            errno);
        return  1;
    }
    printf("ie_ex1: Export program return code is = %d\n", rtn);
    return  0;
} // main

// End of IE_EX1.C
