@echo off
rem /**********************************************************************/
rem /* This batch file is an example of how to perform routine maintenance*/
rem /* on a cc:Mail post office                                           */
rem /**********************************************************************/ 

rem /* Shut down the post office with NPODOWN2 */ 
echo ** Running NPODOWN2 **
NPODOWN2 /N"po_name" /Ppswd /Dm:\ccdata /DISCONNECT /LOCKNOW /MINUTES/5 /BATCH
if errorlevel 3 goto NPERR
if errorlevel 2 goto ESC
if errorlevel 1 goto NPERR

rem /* Run ANALYZE2 on the post office */
echo ** Running first ANALYZE2 **
ANALYZE2 /Dm:\ccdata /DIAGNOSTICS /BATCH  > maint.txt
if errorlevel 3 goto ANERR1
if errorlevel 2 goto ESC
if errorlevel 1 goto ANERR1

rem /* Run CHKSTAT2 on the post office */
echo ** Running CHKSTAT2 **
CHKSTAT2 /N"po_name" /Ppswd /Dm:\ccdata /DIAGNOSTICS/R /BATCH >> maint.txt
if errorlevel 3 goto CHERR
if errorlevel 2 goto ESC
if errorlevel 1 goto CHERR

:RECL
rem /* Run RECLAIM2 on the post office */
echo ** Running RECLAIM2 **
RECLAIM2 /N"po_name" /Ppswd /Dm:\ccdata /BATCH >> maint.txt
if errorlevel 3 goto REERR
if errorlevel 2 goto ESC
if errorlevel 1 goto REERR

rem /* Run ANALYZE2 again on the post office */
echo ** Running second ANALYZE2 **
ANALYZE2 /Dm:\ccdata /DIAGNOSTICS /BATCH >> maint.txt
if errorlevel 3 goto ANERR2
if errorlevel 2 goto ESC
if errorlevel 1 goto ANERR2

echo ** Deleting CCPODOWN file **
NPODOWN2 /N"po_name" /Ppswd /Dm:\ccdata /ENABLE /BATCH

echo ** Maintaince process successful **
goto END

:ANERR1
echo ** First ANALYZE2 reported errors - process ended **
goto END

:NPERR
echo ** NPODOWN2 reported errors - process ended **
goto END

:CHERR
echo ** CHKSTAT2 reported errors - process ended **   
goto END

:REERR
echo ** RECLAIM2 reported errors - process ended **   
goto END

:ANERR2
echo ** Second ANALYZE2 reported errors - process ended **   
goto END

:ESC
echo ** Escape was pressed - process ended **

:END

