@echo off
rem /**********************************************************************/
rem /* This batch file is an example of how to perform routine maintenance */
rem /* on a cc:Mail post office                                            */
rem /**********************************************************************/ 

rem /* Shut down the post office with NPODOWN */ 
echo ** Running NPODOWN **
NPODOWN /N"po_name" /Ppswd /Dm:\ccdata /DISCONNECT /LOCKNOW /MINUTES/5 /BATCH
if errorlevel 3 goto NPERR
if errorlevel 2 goto ESC
if errorlevel 1 goto NPERR

rem /* Run ANALYZE on the post office */
echo ** Running first ANALYZE **
ANALYZE /Dm:\ccdata /DIAGNOSTICS /BATCH  > maint.txt
if errorlevel 3 goto ANERR1
if errorlevel 2 goto ESC
if errorlevel 1 goto ANERR1

rem /* Run CHKSTAT on the post office */
echo ** Running CHKSTAT **
CHKSTAT /N"po_name" /Ppswd /Dm:\ccdata /DIAGNOSTICS/R /BATCH >> maint.txt
if errorlevel 3 goto CHERR
if errorlevel 2 goto ESC
if errorlevel 1 goto CHERR

:RECL
rem /* Run RECLAIM on the post office */
echo ** Running RECLAIM **
RECLAIM /N"po_name" /Ppswd /Dm:\ccdata /BATCH >> maint.txt
if errorlevel 3 goto REERR
if errorlevel 2 goto ESC
if errorlevel 1 goto REERR

rem /* Run ANALYZE again on the post office */
echo ** Running second ANALYZE **
ANALYZE /Dm:\ccdata /DIAGNOSTICS /BATCH >> maint.txt
if errorlevel 3 goto ANERR2
if errorlevel 2 goto ESC
if errorlevel 1 goto ANERR2

echo ** re-open post office **
NPODOWN /N"po_name" /Ppswd /Dm:\ccdata /ENABLE /BATCH

echo ** Maintenance process successful **
goto END

:ANERR1
echo ** First ANALYZE reported errors - process ended **
goto END

:NPERR
echo ** NPODOWN reported errors - process ended **
goto END

:CHERR
echo ** CHKSTAT reported errors - process ended **   
goto END

:REERR
echo ** RECLAIM reported errors - process ended **   
goto END

:ANERR2
echo ** Second ANALYZE reported errors - process ended **   
goto END

:ESC
echo ** Escape was pressed - process ended **

:END


