@echo off
echo **********************************************************************
echo ***                                                                ***
echo ***                SAMPLE CC:MAIL ROUTER BATCH FILE                ***
echo ***                                                                ***
echo ***             THIS FILE WLIL NOT WORK WITHOUT EDITING.           ***
echo ***                                                                ***
rem  ***                                                                ***
rem  ***  Please look at the comments below for directions for editing  ***
rem  ***  this file.  Also, remember that this file may not suit your   ***
rem  ***  needs; use it as an example of how to integrate Out of the    ***
rem  ***  Office into your existing cc:Mail installation.               ***
rem  ***  v1.00                                                         ***
echo **********************************************************************


rem ****************** STEP I: CONFIGURE THE ENVIRONMENT ******************

rem *** Edit the Mail Administrator.  This person will receive mail when
rem *** there is an error.

set MAIL_ADMINISTRATOR=David Potter



rem *** Do other one-time things here.



rem *** If you own Cobblestone Software's MAIL2 program, put it in this
rem *** directory.

if exist MAIL2.EXE echo cc:Mail Router Batch File started. > office.tlk
if exist MAIL2.EXE MAIL2 office.tlk %MAIL_ADMINISTRATOR /text /from Out of the Office
if exist office.tlk del office.tlk




rem ********************** STEP II: TOP OF THE LOOP ***********************
:mainloop

rem *** IF YOU DO NOT USE ROUTER OR GATEWAY....
rem *** Then just use this command: WAIT <number of seconds to wait>
rem *** (uncomment the next line for 15 minutes)
rem *** WAIT 6300

rem *** IF YOU DO USE ROUTER OR GATEWAY....
rem *** Put your cc:Mail ROUTER.EXE (or GATEWAY.EXE) command line here.
rem *** Be sure to include the END/xxM flag on the command line.
rem *** (Example: END/15M will cause ROUTER to quit after fifteen minutes).
rem ***
rem *** The idea here is to have your batch file loop every x minutes.

ROUTER M:\CCDATA com1 2400 END/15M


rem *** Now we run Out of the Office

OFFICE
if errorlevel == 0 goto officefini
rem *** There was an error
if NOT EXIST MAIL2.EXE goto officefini
rem *** There was an error, but I have MAIL2.

if errorlevel == 2 goto nocfgfile
if errorlevel == 3 goto exportexists
if errorlevel == 4 goto missingfile

goto unknown

:nocfgfile
echo Out of the Office cannot find the configuration file. > office.tlk
echo Processing halted. >> office.tlk
mail2 %MAIL_ADMINISTRATOR office.tlk /text /from Out of the Office
del office.tlk
goto officefini

:exportexists
echo Out of the Office halted because the export file existed > office.tlk
echo on startup.  This usually indicated that Out of the Office >> office.tlk
echo crashed last time it ran. >> office.tlk
echo Processing halted. >> office.tlk
mail2 %MAIL_ADMINISTRATOR office.tlk /text /from Out of the Office
del office.tlk
goto officefini

:missingfile
echo Out of the Office halted because it cannot find CHKSTAT.EXE, > office.tlk
echo IMPORT.EXE, or EXPORT.EXE >> office.tlk
echo Processing halted. >> office.tlk
mail2 %MAIL_ADMINISTRATOR office.tlk /text /from Out of the Office
del office.tlk
goto officefini

:unknown
echo Out of the Office halted for an unknown reason. > office.tlk
echo (This indicates errorlevel was not 0-4) >> office.tlk
echo Please check the Out of the Office server. >> office.tlk
echo Processing halted. >> office.tlk
mail2 %MAIL_ADMINISTRATOR office.tlk /text /from Out of the Office
del office.tlk

:officefini

rem **************** STEP III - MIDDLE OF THE LOOP **************************

rem *** Put whatever other commands you want to execute regularly in here

if exist OFFICE.UND if exist MAIL2.EXE mail2 office.und %MAIL_ADMINISTRATOR /text /from OFFICE UNDELIVERABLE FILE
if exist OFFICE.UND if exist MAIL2.EXE if NOT exist CCMAIL.UND del office.und


rem **************** STEP IV - BOTTOM OF THE LOOP **************************

goto mainloop





