@echo off
: Version 1.01 Beta
: {cc:generADEtor}
:
: 12/13/94 - kcd
:
: This Router batch file processes users requests for ADE messages.  
: If a cc:remote/mobile user sends an email to this account, 
: this batch file will then send the user a complete export 
: of the PO as an ADE update message.
: Thus "Synching" the remote users directory with their Home
: Post Office.
:
: Requirements:
:
: cc:Import.exe, Export.exe, Chkstat.exe, Notify.exe, Gateway.exe 
: or Router.exe, Addrflip.exe, 
:
: Set up Variables
:
: PO = Your Hub Post Office or Main Post office
: POPSWD = The PO Admin password
: POPATH = The data path to PO's \CCDATA subdir
: NAME = The GenerADEtor mailbox name
: USRPSWD = The generADEtor's mailbox password
:
: Note: The "NAME" Variable MUST match the name of this batch file.
:       See Router Batch File in the Router Manual for further
:       explanation.
:
: Note: Copy the required files listed above into the home directory
:       for Router.
:
: Note: File ADEINSTR.TXT may be modified to suit your own setup.
:
:
: ==================================================================
:
:TOP
:
: Set up Variables 
:
@set PO=
@set POPSWD=
@set POPATH=M:\CCDATA
@set NAME=generADEtor
@set USRPSWD=
:
echo: 
echo Checking for new queued ADE requests for generADEtor....
:
NOTIFY %NAME% %USRPSWD% %POPATH% CHKONLY
if errorlevel 255 goto error
if errorlevel 1 goto next
if errorlevel 0 goto done
:
:next
:
echo Cleaning up old files
:
if exist ccmupdat del ccmupdat
if exist ccmail.exp del ccmail.exp
if exist ccmail.imp del ccmail.imp
if exist ccmail2.imp del ccmail2.imp
if exist ccmail3.imp del ccmail3.imp
if exist ccmail4.imp del ccmail4.imp
if exist status.imp del status.imp
if exist entries.out del entries.out
:
echo Exporting the 1st new request, if any
:
EXPORT %NAME% %USRPSWD% %POPATH% @CCMAIL.EXP END/1 NAME/1
if errorlevel 6 goto error
if errorlevel 5 goto error
if errorlevel 4 goto error
if errorlevel 3 goto error
if errorlevel 2 goto error
if errorlevel 1 goto error
if errorlevel 0 echo Successful!
:
echo Making a copy for the Admin status message
:
copy ccmail.exp status.imp
:
echo Exporting the PO's directory with /prop
:
EXPORT %PO% %POPSWD% %POPATH% DIRECTORY/PROP @CCMUPDAT >ENTRIES.OUT
if errorlevel 6 goto error
if errorlevel 5 goto error
if errorlevel 4 goto error
if errorlevel 3 goto error
if errorlevel 2 goto error
if errorlevel 1 goto error
if errorlevel 0 echo Successful!
:
echo Flipping the From: & To: fields from ccmail.exp to ccmail.imp
:
ADDRFLIP
:
echo Making a second copy of ccmail.imp for second message
:
COPY ccmail.imp ccmail2.imp
:
echo Creating header for the 1st email - the instructions
:
echo Subject: ADE Instructions (Read me 1st)              >>ccmail2.imp
echo Contents:                                            >>ccmail2.imp
echo Include: adeinstr.txt                                >>ccmail2.imp
echo Include: entries.out                                 >>ccmail2.imp
:
echo Importing instruction email to the requester
:
IMPORT %PO% %POPSWD% %POPATH% @CCMAIL2.IMP   
if errorlevel 6 goto error
if errorlevel 5 goto error
if errorlevel 4 goto error
if errorlevel 3 goto error
if errorlevel 2 goto error
if errorlevel 1 goto error
if errorlevel 0 echo Successful!
:
echo Creating header for 2nd message - the ADE message
:
echo Subject: ADE File attached (Process me 2nd)          >>ccmail.imp
echo Contents:                                            >>ccmail.imp
echo File Item: ccmupdat                                  >>ccmail.imp
:
echo Importing ADE message to requester
:
IMPORT %PO% %POPSWD% %POPATH% @CCMAIL.IMP
if errorlevel 6 goto error
if errorlevel 5 goto error
if errorlevel 4 goto error
if errorlevel 3 goto error
if errorlevel 2 goto error
if errorlevel 1 goto error
if errorlevel 0 echo Successful!
:
echo Creating OK status email to Admin
: Place Admins Name after the TO: field
:
echo Message:                                              >ccmail3.imp
echo From: GenerADEtor                                    >>ccmail3.imp
echo To: ADMINISTRATOR                                    >>ccmail3.imp 
echo Subject: GenerADEtor Sent ADE OK                     >>ccmail3.imp
echo Contents:                                            >>ccmail3.imp
echo *** generADEtor Status Message ***                   >>ccmail3.imp
echo ***                                                  >>ccmail3.imp
echo generADEtor successfully sent an ADE message to      >>ccmail3.imp
echo the user named in the attached file.                 >>ccmail3.imp
echo Number of directory entries exported from the PO:    >>ccmail3.imp
echo Include: entries.out                                 >>ccmail3.imp
echo ***                                                  >>ccmail3.imp 
echo *** End of Status Message ***                        >>ccmail3.imp
echo File Item: status.imp                                >>ccmail3.imp
:
echo Importing status email to Admin
:
IMPORT %PO% %POPSWD% %POPATH% @CCMAIL3.IMP
if errorlevel 6 goto error
if errorlevel 5 goto error
if errorlevel 4 goto error
if errorlevel 3 goto error
if errorlevel 2 goto error
if errorlevel 1 goto error
if errorlevel 0 echo Successful!
:
echo -generADEtor has successfully sent an ADE update to the user!
goto purge
:
:error
echo - generADEtor has detected an error -
:
echo Creating error status email to Admin
:
echo Message:                                              >ccmail4.imp
echo From: GenerADEtor                                    >>ccmail4.imp
echo To: ADMINISTRATOR                                    >>ccmail4.imp 
echo Subject: GenerADEtor Status Error                    >>ccmail4.imp
echo Contents:                                            >>ccmail4.imp
echo *** generADEtor Status Message ***                   >>ccmail4.imp
echo                                                      >>ccmail4.imp
echo generADEtor encountered an error while processing    >>ccmail4.imp
echo an ADE message to the user listed in the attached    >>ccmail4.imp
echo file                                                 >>ccmail4.imp
echo                                                      >>ccmail4.imp 
echo *** End of Status Message ***                        >>ccmail4.imp
echo File Item: status.imp                                >>ccmail4.imp
:
echo Importing status email to Admin
:
IMPORT %PO% %POPSWD% %POPATH% @CCMAIL4.IMP
if errorlevel 1 goto error2
if errorlevel 0 echo Successful!
:
:purge
echo Purging completed generADEtor email requests from mailbox daily 
:
CHKSTAT %PO% %POPSWD% %POPATH% MESSAGES/DELETE/READ/INBOX/GENERADETOR/DAYS/7
if errorlevel 1 goto error2
if errorlevel 0 echo Successful!
:
goto top
:
:error2
echo generADEtor has encountered a 2nd error while processing
echo an original error message.
goto top
:
:none
:
echo - no new ADE requests for generADEtor to process -
:
echo - Cleaning up old files -
:
if exist ccmupdat del ccmupdat
if exist ccmail.exp del ccmail.exp
if exist ccmail.imp del ccmail.imp
if exist ccmail2.imp del ccmail2.imp
if exist ccmail3.imp del ccmail3.imp
if exist ccmail4.imp del ccmail4.imp
if exist status.imp del status.imp
if exist entries.out del entries.out
:
:done


