/*
 * %Z%%W% %I%
 * ===========================================================================
 * IBM Confidential
 * OCO Source Materials
 * Licensed Materials - Property of IBM
 * IBM Semeru Runtime Certified Edition for z/OS
 *
 * (C) Copyright IBM Corp. 2007, 2023
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright Office.
 * 
 * DISCLAIMER: 
 * The following [enclosed] code is sample code created by IBM 
 * Corporation.  This sample code is not part of any standard IBM product 
 * and is provided to you solely for the purpose of assisting you in the 
 * development of your applications.  The code is provided 'AS IS', 
 * without warranty of any kind.  IBM shall not be liable for any damages 
 * arising out of your use of the sample code, even if they have been 
 * advised of the possibility of such damages.
 * ===========================================================================
 */
package com.ibm.jzos.sample.fields;
import com.ibm.jzos.fields.*;

// Generated by com.ibm.jzos.recordgen.asm.RecordClassGenerator on: Tue Jul 17 11:59:33 EDT 2007

/** 
 * Maps a Security section of SMF record 83 (RACF Security information).
 * This code (excluding these notes) was generated using 
 * <code>com.ibm.jzos.recordgen.asm.RecordClassGenerator</code> using the following JCL:
 * <pre><code>
//ASSEMBLE EXEC ASMAC,PARM='ADATA,LIST,NOTERM,NODECK,NOOBJECT' 
//C.SYSIN DD * 
      IFASMFR 83 
      END 
//C.SYSADATA DD DSN=&&ADATA,DISP=(NEW,PASS), 
//           SPACE=(CYL,(3,1)) 
//* 
//JAVA EXEC PROC=EXJZOSVM,VERSION='50' 
//MAINARGS DD * 
com.ibm.jzos.recordgen.asm.RecordClassGenerator 
  section=SMF83DS1 
  bufoffset=true 
  package=com.ibm.jzos.sample.fields 
  class=Smf83Security
//SYSADATA DD DSN=&&ADATA,DISP=(OLD,DELETE) 
//STDOUT DD PATH='/home/user/Smf83Security.java', 
//          PATHOPTS=(OWRONLY,OCREAT), 
//          PATHMODE=SIRWXU 
//STDENV DD * 
...
   </code></pre>
 * @see Smf83Record Smf83Record for a class that glues together the components of a SMF 83 record
 * @since 2.1.0
 */

public class Smf83Security {

	protected static AssemblerDatatypeFactory factory = new AssemblerDatatypeFactory();

	/** *                                                                  @D6A <br/>
	    *        SECURITY SECTION - DATA SECTION 1                         @D6A <br/>
	    *                                                                  @D6A <br/>
	    SMF83DS1 DSECT ,        SECURITY SECTION - DATA SECTION 1          @D6A  */
	public static int SMF83DS1 = factory.getOffset();

	/** SMF83DF3 DS    BL4      FIELDS IN DATA SECTION 1 THAT ARE          @D6A  */
	protected static BinaryAsLongField SMF83DF3 = factory.getBinaryAsLongField(4, false);

	/** *                       NOT IN SMF TYPE 80 RECORD                  @D6A <br/>
	             ORG   SMF83DF3                                            @D6A  <br/>
	    SMF83LNK DS    BL4      LINK VALUE TO CONNECT DATA SET NAMES       @M5A  */
	static { factory.incrementOffset(-4); }
	protected static BinaryAsLongField SMF83LNK = factory.getBinaryAsLongField(4, false);

	/** *                       WITH ORIGINAL RACF COMMAND                 @M5A <br/>
	    SMF83DES DS    BL2      DESCRIPTOR FLAGS                           @M5A  */
	protected static BinaryAsIntField SMF83DES = factory.getBinaryAsIntField(2, false);

	/** *                       BIT MEANING WHEN SET                       @M5A <br/>
	    *                       BIT 0 - THIS EVENT IS A VIOLATION          @M5A <br/>
	    *                       BIT 1 - USER NOT DEFINED TO RACF           @M5A <br/>
	    *                       BIT 2 - RCD CONTAINS VERSION INDICATOR     @M5A <br/>
	    *                       BIT 3 - THIS EVENT IS A WARNING            @M5A <br/>
	    *                       BIT 4 - SMF83VRM CONTAINS A VERSION        @M5A <br/>
	    *                               RELEASE, AND MODIFICATION NUMBER   @M5A <br/>
	    *                               (VRRM)                             @M5A <br/>
	    *                       BIT 5 - CALLER OF R_AUDITX SERVICE INDICATED <br/>
	    *                               TO ALWAYS LOG                      @MMA <br/>
	    *                       BITS 6-15 - RESERVED                       @MMC <br/>
	    SMF83EVT DS    BL1      EVENT CODE                                 @M5A  */
	protected static BinaryAsIntField SMF83EVT = factory.getBinaryAsIntField(1, false);

	/** *                       8 - ADDSD                                  @M5A <br/>
	    *                       11- ALTDSD                                 @M5A <br/>
	    *                       15- DELDSD                                 @M5A <br/>
	    *                       20- RALTER                                 @M5A <br/>
	    *                       21- RDEFINE                                @M5A <br/>
	    *                       22- RDELETE                                @M5A <br/>
	    SMF83EVQ DS    BL1      EVENT CODE QUALIFIER                       @M5A  */
	protected static BinaryAsIntField SMF83EVQ = factory.getBinaryAsIntField(1, false);

	/** SMF83USR DS    CL8      USER ID FOR WHICH THIS EVENT RECORDED      @M5A  */
	protected static StringField SMF83USR = factory.getStringField(8, true);

	/** SMF83GRP DS    CL8      GROUP TO WHICH USER WAS CONNECTED          @M5A  */
	protected static StringField SMF83GRP = factory.getStringField(8, true);

	/** SMF83REL DS    BL2      OFFSET OF FIRST RELOCATE SECTION FROM      @M5A  */
	protected static BinaryAsIntField SMF83REL = factory.getBinaryAsIntField(2, false);

	/** *                       BEGINNING OF THE RECORD HEADER             @M5A <br/>
	    SMF83CNT DS    BL2      NUMBER OF RELOCATE SECTIONS                @M5A  */
	protected static BinaryAsIntField SMF83CNT = factory.getBinaryAsIntField(2, false);

	/** SMF83ATH DS    BL1      SPECIAL AUTHORITIES USED                   @M5A  */
	protected static BinaryAsIntField SMF83ATH = factory.getBinaryAsIntField(1, false);

	/** *                       BIT MEANINGS WHEN SET -                    @M5A <br/>
	    *                       BIT 0 - NORMAL AUTHORITY CHECK             @M5A <br/>
	    *                       BIT 1 - SPECIAL ATTRIBUTE                  @M5A <br/>
	    *                       BIT 2 - OPERATIONS ATTRIBUTE               @M5A <br/>
	    *                       BIT 3 - AUDITOR ATTRIBUTE                  @M5A <br/>
	    *                       BIT 4 - INSTALLATION EXIT ACTION           @M5A <br/>
	    *                       BIT 5 - FAILSOFT PROCESSING                @M5A <br/>
	    *                       BIT 6 - BYPASSED - USERID=*BYPASS*         @D5A <br/>
	    *                       BIT 7 - TRUSTED ATTRIBUTE                  @01C <br/>
	    SMF83REA DS    BL1      REASON FOR LOGGING                         @M5A  */
	protected static BinaryAsIntField SMF83REA = factory.getBinaryAsIntField(1, false);

	/** *                       BIT MEANINGS WHEN SET:                     @M5A <br/>
	    *                       BIT 0 - CHANGES TO THIS CLASS OF           @M5A <br/>
	    *                       PROFILE BEING AUDITED                      @M5A <br/>
	    *                       BIT 1 - USER BEING AUDITED                 @M5A <br/>
	    *                       BIT 2 - SPECIAL USERS BEING AUDITED        @M5A <br/>
	    *                       BIT 3 - ACCESS TO ENTITY BEING AUDITED     @M5A <br/>
	    *                               DUE TO AUDIT OPTION                @M5A <br/>
	    *                               OR RACHECK INSTALLATION EXIT       @M5A <br/>
	    *                               REQUESTED LOGGING, OR TO           @M5A <br/>
	    *                               FAILSOFT  PROCESSING               @M5A <br/>
	    *                       BIT 4 - *RACINIT* FAILURE                  @M5A <br/>
	    *                       BIT 5 - THIS COMMAND IS ALWAYS AUDITED     @M5A <br/>
	    *                       BIT 6 - VIOLATION DETECTED AND CMDVIOL     @M5A <br/>
	    *                               IN EFFECT                          @M5A <br/>
	    *                       BIT 7 - ACCESS TO ENTITY BEING AUDITED     @M5A <br/>
	    *                               DUE TO GLOBALAUDIT OPTION          @M5A <br/>
	    SMF83TLV DS    BL1      TERMINAL LEVEL NUMBER OF FOREGROUND        @M5A  */
	protected static BinaryAsIntField SMF83TLV = factory.getBinaryAsIntField(1, false);

	/** *                       USER (ZERO IF NOT AVAILABLE OR NOT         @M5A <br/>
	    *                       VERIFIED)                                  @M5A <br/>
	    SMF83ERR DS    BL1      COMMAND PROCESSING ERROR FLAG              @M5A  */
	protected static BinaryAsIntField SMF83ERR = factory.getBinaryAsIntField(1, false);

	/** *                       BIT MEANINGS WHEN SET:                     @M5A <br/>
	    *                       BIT 0 - COMMAND HAD ERROR AND COULD        @M5A <br/>
	    *                               NOT BACKOUT SOME CHANGES           @M5A <br/>
	    *                       BIT 1 - NO PROFILE UPDATES MADE            @M5A <br/>
	    *                               BECAUSE OF ERROR IN PROCESSING     @M5A <br/>
	    *                       BIT 2-7 - RESERVED                         @M5A <br/>
	    SMF83TRM DS    CL8      TERMINAL ID OF FOREGROUND USER             @M5A  */
	protected static StringField SMF83TRM = factory.getStringField(8, true);

	/** *                       (ZEROES IF NOT AVAILABLE)                  @M5A <br/>
	    SMF83JBN DS    CL8      JOB NAME                                   @M5A  */
	protected static StringField SMF83JBN = factory.getStringField(8, true);

	/** SMF83RST DS    BL4      TIME READER RECOGNIZED JOB CARD            @M5A  */
	protected static BinaryAsLongField SMF83RST = factory.getBinaryAsLongField(4, false);

	/** *                       IN HUNDREDTHS OF SECONDS                   @M5A <br/>
	    SMF83RSD DS    PL4      DATE READER RECOGNIZED JOB CARD            @M5A  */
	protected static PackedDecimalAsIntField SMF83RSD = factory.getPackedDecimalAsIntField(4, true);

	/** *                       00YYDDDF FORMAT                            @M5A <br/>
	    SMF83UID DS    CL8      USER IDENTIFICATION                        @M5A  */
	protected static StringField SMF83UID = factory.getStringField(8, true);

	/** SMF83VER DS    XL1      VERSION INDICATOR FROM RCVT                @M5A  */
	protected static BinaryAsIntField SMF83VER = factory.getBinaryAsIntField(1, false);

	/** SMF83RE2 DS    BL1      REASON FOR LOGGING CONTINUED               @M5A  */
	protected static BinaryAsIntField SMF83RE2 = factory.getBinaryAsIntField(1, false);

	/** *                       BIT MEANINGS WHEN SET:                     @M5A <br/>
	    *                       BIT 0 - AUDITING BY SECURITY LEVEL         @M5A <br/>
	    *                       BIT 1 - AUDITING BY LOGOPTIONS             @M5A <br/>
	    *                       BIT 2 - AUDITING BY SETROPTS SECLABELAUDIT @M5A <br/>
	    *                       BIT 3 - AUDITING BY SETROPTS COMPATMODE    @D3A <br/>
	    *                       BITS 4-7 - RESERVED                        @D3C <br/>
	    SMF83VRM DS    CL4      RACF VERSION, RELEASE, AND MODIFICATION    @M5A  */
	protected static StringField SMF83VRM = factory.getStringField(4, true);

	/** *                       NUMBER (VRRM)                              @M5A <br/>
	    SMF83SEC DS    CL8      SECLABEL OF USER                           @M5A  */
	protected static StringField SMF83SEC = factory.getStringField(8, true);

	/** SMF83AU2 DS    BL1      AUTHORITY USED CONTINUED                   @MJA  */
	protected static BinaryAsIntField SMF83AU2 = factory.getBinaryAsIntField(1, false);

	/** *                       BIT 0 - 1 => OMVS SUPERUSER                @MJA <br/>
	    *                       BIT 1 - 1 => OMVS SYSTEM FUNCTION          @MJA <br/>
	    *                       BIT 2-7 - RESERVED                         @MJA <br/>
	    SMF83RSV DS    BL1      RESERVED                                   @MJA  */
	protected static BinaryAsIntField SMF83RSV = factory.getBinaryAsIntField(1, false);

	/** SMF83US2 DS    CL8      USER ID FOR THE ADDRESS SPACE              @MKC  */
	protected static StringField SMF83US2 = factory.getStringField(8, true);

	/** *                         FOR WHICH THIS EVENT RECORDED            @MJA <br/>
	    SMF83GR2 DS    CL8      GROUP TO WHICH THE ADRESS SPACE USER       @MKC  */
	protected static StringField SMF83GR2 = factory.getStringField(8, true);

	protected byte[] bytes;
	protected int bufOffset;

	// Instance variables used to cache field values 
	private Long smf83df3;
	private Long smf83lnk;
	private Integer smf83des;
	private Integer smf83evt;
	private Integer smf83evq;
	private String smf83usr;
	private String smf83grp;
	private Integer smf83rel;
	private Integer smf83cnt;
	private Integer smf83ath;
	private Integer smf83rea;
	private Integer smf83tlv;
	private Integer smf83err;
	private String smf83trm;
	private String smf83jbn;
	private Long smf83rst;
	private Integer smf83rsd;
	private String smf83uid;
	private Integer smf83ver;
	private Integer smf83re2;
	private String smf83vrm;
	private String smf83sec;
	private Integer smf83au2;
	private Integer smf83rsv;
	private String smf83us2;
	private String smf83gr2;


	public Smf83Security(byte[] buffer, int bufOffset) {
		this.bytes = buffer;
		this.bufOffset = bufOffset;
	}


	public long getSmf83df3() {
		if (smf83df3 == null) {
			smf83df3 = Long.valueOf(SMF83DF3.getLong(bytes, bufOffset));
		}
		return smf83df3.longValue();
	}

	public void setSmf83df3(long smf83df3) {
		if (SMF83DF3.equals(this.smf83df3, smf83df3))
			return;
		SMF83DF3.putLong(smf83df3, bytes, bufOffset);
		this.smf83df3 = Long.valueOf(smf83df3);
	}

	public long getSmf83lnk() {
		if (smf83lnk == null) {
			smf83lnk = Long.valueOf(SMF83LNK.getLong(bytes, bufOffset));
		}
		return smf83lnk.longValue();
	}

	public void setSmf83lnk(long smf83lnk) {
		if (SMF83LNK.equals(this.smf83lnk, smf83lnk))
			return;
		SMF83LNK.putLong(smf83lnk, bytes, bufOffset);
		this.smf83lnk = Long.valueOf(smf83lnk);
	}

	public int getSmf83des() {
		if (smf83des == null) {
			smf83des = Integer.valueOf(SMF83DES.getInt(bytes, bufOffset));
		}
		return smf83des.intValue();
	}

	public void setSmf83des(int smf83des) {
		if (SMF83DES.equals(this.smf83des, smf83des))
			return;
		SMF83DES.putInt(smf83des, bytes, bufOffset);
		this.smf83des = Integer.valueOf(smf83des);
	}

	public int getSmf83evt() {
		if (smf83evt == null) {
			smf83evt = Integer.valueOf(SMF83EVT.getInt(bytes, bufOffset));
		}
		return smf83evt.intValue();
	}

	public void setSmf83evt(int smf83evt) {
		if (SMF83EVT.equals(this.smf83evt, smf83evt))
			return;
		SMF83EVT.putInt(smf83evt, bytes, bufOffset);
		this.smf83evt = Integer.valueOf(smf83evt);
	}

	public int getSmf83evq() {
		if (smf83evq == null) {
			smf83evq = Integer.valueOf(SMF83EVQ.getInt(bytes, bufOffset));
		}
		return smf83evq.intValue();
	}

	public void setSmf83evq(int smf83evq) {
		if (SMF83EVQ.equals(this.smf83evq, smf83evq))
			return;
		SMF83EVQ.putInt(smf83evq, bytes, bufOffset);
		this.smf83evq = Integer.valueOf(smf83evq);
	}

	public String getSmf83usr() {
		if (smf83usr == null) {
			smf83usr = SMF83USR.getString(bytes, bufOffset);
		}
		return smf83usr;
	}

	public void setSmf83usr(String smf83usr) {
		if (SMF83USR.equals(this.smf83usr, smf83usr))
			return;
		SMF83USR.putString(smf83usr, bytes, bufOffset);
		this.smf83usr = smf83usr;
	}

	public String getSmf83grp() {
		if (smf83grp == null) {
			smf83grp = SMF83GRP.getString(bytes, bufOffset);
		}
		return smf83grp;
	}

	public void setSmf83grp(String smf83grp) {
		if (SMF83GRP.equals(this.smf83grp, smf83grp))
			return;
		SMF83GRP.putString(smf83grp, bytes, bufOffset);
		this.smf83grp = smf83grp;
	}

	public int getSmf83rel() {
		if (smf83rel == null) {
			smf83rel = Integer.valueOf(SMF83REL.getInt(bytes, bufOffset));
		}
		return smf83rel.intValue();
	}

	public void setSmf83rel(int smf83rel) {
		if (SMF83REL.equals(this.smf83rel, smf83rel))
			return;
		SMF83REL.putInt(smf83rel, bytes, bufOffset);
		this.smf83rel = Integer.valueOf(smf83rel);
	}

	public int getSmf83cnt() {
		if (smf83cnt == null) {
			smf83cnt = Integer.valueOf(SMF83CNT.getInt(bytes, bufOffset));
		}
		return smf83cnt.intValue();
	}

	public void setSmf83cnt(int smf83cnt) {
		if (SMF83CNT.equals(this.smf83cnt, smf83cnt))
			return;
		SMF83CNT.putInt(smf83cnt, bytes, bufOffset);
		this.smf83cnt = Integer.valueOf(smf83cnt);
	}

	public int getSmf83ath() {
		if (smf83ath == null) {
			smf83ath = Integer.valueOf(SMF83ATH.getInt(bytes, bufOffset));
		}
		return smf83ath.intValue();
	}

	public void setSmf83ath(int smf83ath) {
		if (SMF83ATH.equals(this.smf83ath, smf83ath))
			return;
		SMF83ATH.putInt(smf83ath, bytes, bufOffset);
		this.smf83ath = Integer.valueOf(smf83ath);
	}

	public int getSmf83rea() {
		if (smf83rea == null) {
			smf83rea = Integer.valueOf(SMF83REA.getInt(bytes, bufOffset));
		}
		return smf83rea.intValue();
	}

	public void setSmf83rea(int smf83rea) {
		if (SMF83REA.equals(this.smf83rea, smf83rea))
			return;
		SMF83REA.putInt(smf83rea, bytes, bufOffset);
		this.smf83rea = Integer.valueOf(smf83rea);
	}

	public int getSmf83tlv() {
		if (smf83tlv == null) {
			smf83tlv = Integer.valueOf(SMF83TLV.getInt(bytes, bufOffset));
		}
		return smf83tlv.intValue();
	}

	public void setSmf83tlv(int smf83tlv) {
		if (SMF83TLV.equals(this.smf83tlv, smf83tlv))
			return;
		SMF83TLV.putInt(smf83tlv, bytes, bufOffset);
		this.smf83tlv = Integer.valueOf(smf83tlv);
	}

	public int getSmf83err() {
		if (smf83err == null) {
			smf83err = Integer.valueOf(SMF83ERR.getInt(bytes, bufOffset));
		}
		return smf83err.intValue();
	}

	public void setSmf83err(int smf83err) {
		if (SMF83ERR.equals(this.smf83err, smf83err))
			return;
		SMF83ERR.putInt(smf83err, bytes, bufOffset);
		this.smf83err = Integer.valueOf(smf83err);
	}

	public String getSmf83trm() {
		if (smf83trm == null) {
			smf83trm = SMF83TRM.getString(bytes, bufOffset);
		}
		return smf83trm;
	}

	public void setSmf83trm(String smf83trm) {
		if (SMF83TRM.equals(this.smf83trm, smf83trm))
			return;
		SMF83TRM.putString(smf83trm, bytes, bufOffset);
		this.smf83trm = smf83trm;
	}

	public String getSmf83jbn() {
		if (smf83jbn == null) {
			smf83jbn = SMF83JBN.getString(bytes, bufOffset);
		}
		return smf83jbn;
	}

	public void setSmf83jbn(String smf83jbn) {
		if (SMF83JBN.equals(this.smf83jbn, smf83jbn))
			return;
		SMF83JBN.putString(smf83jbn, bytes, bufOffset);
		this.smf83jbn = smf83jbn;
	}

	public long getSmf83rst() {
		if (smf83rst == null) {
			smf83rst = Long.valueOf(SMF83RST.getLong(bytes, bufOffset));
		}
		return smf83rst.longValue();
	}

	public void setSmf83rst(long smf83rst) {
		if (SMF83RST.equals(this.smf83rst, smf83rst))
			return;
		SMF83RST.putLong(smf83rst, bytes, bufOffset);
		this.smf83rst = Long.valueOf(smf83rst);
	}

	public int getSmf83rsd() {
		if (smf83rsd == null) {
			smf83rsd = Integer.valueOf(SMF83RSD.getInt(bytes, bufOffset));
		}
		return smf83rsd.intValue();
	}

	public void setSmf83rsd(int smf83rsd) {
		if (SMF83RSD.equals(this.smf83rsd, smf83rsd))
			return;
		SMF83RSD.putInt(smf83rsd, bytes, bufOffset);
		this.smf83rsd = Integer.valueOf(smf83rsd);
	}

	public String getSmf83uid() {
		if (smf83uid == null) {
			smf83uid = SMF83UID.getString(bytes, bufOffset);
		}
		return smf83uid;
	}

	public void setSmf83uid(String smf83uid) {
		if (SMF83UID.equals(this.smf83uid, smf83uid))
			return;
		SMF83UID.putString(smf83uid, bytes, bufOffset);
		this.smf83uid = smf83uid;
	}

	public int getSmf83ver() {
		if (smf83ver == null) {
			smf83ver = Integer.valueOf(SMF83VER.getInt(bytes, bufOffset));
		}
		return smf83ver.intValue();
	}

	public void setSmf83ver(int smf83ver) {
		if (SMF83VER.equals(this.smf83ver, smf83ver))
			return;
		SMF83VER.putInt(smf83ver, bytes, bufOffset);
		this.smf83ver = Integer.valueOf(smf83ver);
	}

	public int getSmf83re2() {
		if (smf83re2 == null) {
			smf83re2 = Integer.valueOf(SMF83RE2.getInt(bytes, bufOffset));
		}
		return smf83re2.intValue();
	}

	public void setSmf83re2(int smf83re2) {
		if (SMF83RE2.equals(this.smf83re2, smf83re2))
			return;
		SMF83RE2.putInt(smf83re2, bytes, bufOffset);
		this.smf83re2 = Integer.valueOf(smf83re2);
	}

	public String getSmf83vrm() {
		if (smf83vrm == null) {
			smf83vrm = SMF83VRM.getString(bytes, bufOffset);
		}
		return smf83vrm;
	}

	public void setSmf83vrm(String smf83vrm) {
		if (SMF83VRM.equals(this.smf83vrm, smf83vrm))
			return;
		SMF83VRM.putString(smf83vrm, bytes, bufOffset);
		this.smf83vrm = smf83vrm;
	}

	public String getSmf83sec() {
		if (smf83sec == null) {
			smf83sec = SMF83SEC.getString(bytes, bufOffset);
		}
		return smf83sec;
	}

	public void setSmf83sec(String smf83sec) {
		if (SMF83SEC.equals(this.smf83sec, smf83sec))
			return;
		SMF83SEC.putString(smf83sec, bytes, bufOffset);
		this.smf83sec = smf83sec;
	}

	public int getSmf83au2() {
		if (smf83au2 == null) {
			smf83au2 = Integer.valueOf(SMF83AU2.getInt(bytes, bufOffset));
		}
		return smf83au2.intValue();
	}

	public void setSmf83au2(int smf83au2) {
		if (SMF83AU2.equals(this.smf83au2, smf83au2))
			return;
		SMF83AU2.putInt(smf83au2, bytes, bufOffset);
		this.smf83au2 = Integer.valueOf(smf83au2);
	}

	public int getSmf83rsv() {
		if (smf83rsv == null) {
			smf83rsv = Integer.valueOf(SMF83RSV.getInt(bytes, bufOffset));
		}
		return smf83rsv.intValue();
	}

	public void setSmf83rsv(int smf83rsv) {
		if (SMF83RSV.equals(this.smf83rsv, smf83rsv))
			return;
		SMF83RSV.putInt(smf83rsv, bytes, bufOffset);
		this.smf83rsv = Integer.valueOf(smf83rsv);
	}

	public String getSmf83us2() {
		if (smf83us2 == null) {
			smf83us2 = SMF83US2.getString(bytes, bufOffset);
		}
		return smf83us2;
	}

	public void setSmf83us2(String smf83us2) {
		if (SMF83US2.equals(this.smf83us2, smf83us2))
			return;
		SMF83US2.putString(smf83us2, bytes, bufOffset);
		this.smf83us2 = smf83us2;
	}

	public String getSmf83gr2() {
		if (smf83gr2 == null) {
			smf83gr2 = SMF83GR2.getString(bytes, bufOffset);
		}
		return smf83gr2;
	}

	public void setSmf83gr2(String smf83gr2) {
		if (SMF83GR2.equals(this.smf83gr2, smf83gr2))
			return;
		SMF83GR2.putString(smf83gr2, bytes, bufOffset);
		this.smf83gr2 = smf83gr2;
	}

}
