/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.vsam.file;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;

public class UpdateKsdsRecords {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            UpdateKsdsRecords.usage();
        }
        String fileName = args[0];
        UpdateKsdsRecords.updateRecords(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRecords(String fileName) throws Exception {
        int lrecl = 80;
        int keyLen = 8;
        String options = "rb+,type=record";
        System.out.println("fileName=" + fileName);
        System.out.println("options=" + options);
        ZFile zfile = new ZFile(fileName, options);
        byte[] recBuf = new byte[lrecl];
        byte[] key = "50000005".getBytes("IBM-1047");
        try {
            zfile.rewind();
            int nRead = zfile.read(recBuf);
            if (nRead != -1) {
                boolean located = zfile.locate(key, 0, keyLen, 3);
                System.out.println("located=" + located);
                nRead = zfile.read(recBuf);
                String record50000005 = new String(recBuf, ZUtil.getDefaultPlatformEncoding());
                System.out.println("nRead=" + nRead + " Record with Primary Key 50000005=" + record50000005);
                String pk = record50000005.substring(0, 8);
                byte[] updateRecord = UpdateKsdsRecords.padToLength(pk + "This record is modified", lrecl).getBytes("IBM-1047");
                zfile.update(updateRecord);
                System.out.println("Record 50000005 updated to=" + new String(updateRecord));
            } else {
                System.out.println("nRead=" + nRead);
            }
        }
        finally {
            zfile.close();
        }
    }

    static String padToLength(String s, int len) {
        StringBuffer sb = new StringBuffer(len);
        sb.append(s);
        for (int i = s.length(); i < len; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private static void usage() {
        System.out.println("UpdateKsdsRecords - Demonstrates how to update records in a VSAM dataset.");
        System.out.println("Usage:");
        System.out.println("\tjava com.ibm.jzos.sample.vsam.file.UpdateKsdsRecords file");
        System.out.println("\tfile: The name of the VSAM dataset to update");
        System.out.println("\t\tExample file");
        System.out.println("\t\tVSAM Dataset: //'TSOUSER.PRIVATE.JZOS.SAMPLES.KSDS'");
        System.out.println();
        System.exit(0);
    }
}

