/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.vsam.file;

import com.ibm.jzos.ZFile;

public class SeqWriteKsds {
    public static void main(String[] args) {
        if (args.length != 1) {
            SeqWriteKsds.usage();
        }
        String fileName = args[0];
        SeqWriteKsds.writeRecords(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRecords(String fileName) {
        String options = "wb+,type=record";
        ZFile zfile = null;
        String[] testString = new String[]{"10000001IIIIdddThis is test record 1", "20000002HHHHcccThis is test record 2", "30000003GGGGbbbThis is test record 3", "40000004FFFFaaaThis is test record 4", "50000005EEEEdddThis is test record 5", "60000006DDDDcccThis is test record 6", "70000007CCCCbbbThis is test record 7", "80000008BBBBaaaThis is test record 8", "90000009AAAAdddThis is test record 9"};
        try {
            int numRecords;
            System.out.println("fileName=" + fileName);
            System.out.println("options=" + options);
            zfile = new ZFile(fileName, options);
            int lrecl = 80;
            int keyLen = 8;
            System.out.println("getLrecl=" + lrecl + " keyLen=" + keyLen);
            for (numRecords = 0; numRecords < testString.length; ++numRecords) {
                System.out.println("testString[numRecords]=" + testString[numRecords]);
                byte[] record = SeqWriteKsds.padToLength(testString[numRecords], lrecl).getBytes("IBM-1047");
                zfile.write(record);
            }
            System.out.println("number of records written: " + numRecords);
        }
        catch (Exception e) {
            System.out.println("Failed to write " + fileName + ". Exception caught: ");
            e.printStackTrace();
        }
        finally {
            try {
                if (zfile != null) {
                    zfile.close();
                }
            }
            catch (Exception e) {
                System.out.println("Failed to close the file " + fileName + ". Exception caught: ");
                e.printStackTrace();
            }
        }
    }

    static String padToLength(String s, int len) {
        StringBuffer sb = new StringBuffer(len);
        sb.append(s);
        for (int i = s.length(); i < len; ++i) {
            sb.append(' ');
        }
        System.out.println("sb.length=" + sb.length());
        return sb.toString();
    }

    private static void usage() {
        System.out.println("SeqWriteKsds -- Demonstrates how to write records to a VSAM dataset.");
        System.out.println("Usage:");
        System.out.println("\tjava com.ibm.jzos.sample.vsam.file.SeqWriteKsds fileName");
        System.out.println("\tfileName: The name of the VSAM dataset to write to");
        System.out.println("\t\tExample fileName");
        System.out.println("\t\tVSAM Dataset:  //'TSOUSER.PRIVATE.JZOS.SAMPLES.VSAM.KSDS'");
        System.out.println();
        System.exit(0);
    }
}

