/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.vsam.file;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;

public class SeqReadKsds {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            SeqReadKsds.usage();
        }
        String fileName = args[0];
        SeqReadKsds.readRecords(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readRecords(String fileName) throws Exception {
        int lrecl = 80;
        String options = "rb+,type=record";
        byte[] recBuf = new byte[lrecl];
        try (ZFile zfile = new ZFile(fileName, options);){
            while (zfile.read(recBuf) != -1) {
                String record = new String(recBuf, ZUtil.getDefaultPlatformEncoding());
                System.out.println("Record=" + record);
            }
        }
    }

    private static void usage() {
        System.out.println("SeqReadKsds - Demonstrates how to read records from a VSAM KSDS dataset.");
        System.out.println("Usage:");
        System.out.println("\tjava com.ibm.jzos.sample.vsam.file.SeqReadKsds file");
        System.out.println("\tfile: The name of the VSAM dataset to read records from");
        System.out.println("\t\tExample file");
        System.out.println("\t\tVSAM Dataset: //'TSOUSER.PRIVATE.JZOS.SAMPLES.KSDS'");
        System.out.println();
        System.exit(0);
    }
}

