/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.vsam.cluster;

import com.ibm.jzos.AccessMethodServices;
import com.ibm.jzos.ZFile;

public class DeleteKsdsCluster {
    public static void main(String[] args) {
        if (args.length != 1) {
            DeleteKsdsCluster.usage();
        }
        String dsName = args[0];
        DeleteKsdsCluster.deleteCluster(ZFile.getFullyQualifiedDSN((String)dsName));
    }

    public static void deleteCluster(String dsname) {
        try {
            System.out.println("dsName: " + dsname);
            if (dsname.startsWith("//")) {
                dsname = dsname.substring(2);
            }
            dsname = dsname.toUpperCase();
            String def1 = "DELETE ";
            def1 = def1.concat(dsname).concat(" -");
            AccessMethodServices ams = new AccessMethodServices();
            ams.addInputLine(def1);
            ams.addInputLine("PURGE ERASE                       ");
            int rc = ams.execute();
            String out = ams.getOutputLines();
            System.out.println("IDCAMS return code: " + rc);
            System.out.println("IDCAMS return text: " + out);
        }
        catch (Exception e) {
            System.out.println("Failed to delete VSAM: Exception caught: ");
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("DeleteKsdsCluster -- Delete a VSAM KSDS Cluster.");
        System.out.println("Usage:");
        System.out.println("\tjava com.ibm.jzos.sample.vsam.cluster.DeleteKsdsCluster dsName");
        System.out.println("\tdsName: The fully qualified dataset name");
        System.out.println("\t\tExample dsName");
        System.out.println("\t\t//'TSOUSER.PRIVATE.JZOS.SAMPLES.VSAM.KSDS'");
        System.out.println();
        System.exit(0);
    }
}

