/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.nonvsam.file;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;

public class WriteFile {
    public static void main(String[] args) {
        if (args.length < 1) {
            WriteFile.usage();
        }
        String fileName = args[0];
        int count = 10;
        if (args.length >= 2) {
            count = Integer.parseInt(args[1]);
        }
        WriteFile.writeFile(fileName, count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String fileName, int count) {
        ZFile dsnFile = null;
        String s = new String("test string");
        long elapsed = System.currentTimeMillis();
        long cpu = ZUtil.getCpuTimeMicros();
        try {
            int numWrites;
            dsnFile = new ZFile(fileName, "wb,type=record,noseek");
            for (numWrites = 0; numWrites < count; ++numWrites) {
                String t = numWrites + " " + s;
                dsnFile.write(t.getBytes());
            }
            System.out.println("numWrites = " + numWrites);
            elapsed = System.currentTimeMillis() - elapsed;
            cpu = (ZUtil.getCpuTimeMicros() - cpu) / 1000L;
            System.out.println("Elapsed: " + elapsed + "ms, CPU: " + cpu + "ms");
        }
        catch (Exception e) {
            System.out.println("Unable to write to " + fileName);
            e.printStackTrace();
        }
        finally {
            try {
                if (dsnFile != null) {
                    dsnFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void usage() {
        System.out.println("WriteFile -- Demonstrates how to write data to a file sequentially.");
        System.out.println("Usage:");
        System.out.println("\tjava com.ibm.jzos.sample.nonvsam.file.WriteFile fileName <numrecs>");
        System.out.println("\tfileName: The name of the file to write.");
        System.out.println("\t\tExample fileName");
        System.out.println("\t\t\tPS Dataset: //'USERID.PRIVATE.SAMPLE'");
        System.out.println("\t\t\tPDS Member: //'USERID.PRIVATE.PDS(SAMPLE)'");
        System.out.println();
        System.exit(0);
    }
}

