/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.nonvsam.file;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;

public class RandomAccessFile {
    public static void main(String[] args) {
        if (args.length != 1) {
            RandomAccessFile.usage();
        }
        String fileName = args[0];
        RandomAccessFile.randomAccess(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void randomAccess(String fileName) {
        ZFile dsnFile = null;
        try {
            dsnFile = new ZFile(fileName, "rb,type=record");
            byte[] recBuf = new byte[dsnFile.getLrecl()];
            int bytesRead = dsnFile.read(recBuf);
            System.out.println("bytesRead=" + bytesRead + " 1st record (record 0):" + new String(recBuf, ZUtil.getDefaultPlatformEncoding()));
            dsnFile.seek(-1L, 2);
            bytesRead = dsnFile.read(recBuf);
            System.out.println("bytesRead=" + bytesRead + " last record (record n-1):" + new String(recBuf, ZUtil.getDefaultPlatformEncoding()));
            dsnFile.seek(1L, 0);
            bytesRead = dsnFile.read(recBuf);
            System.out.println("bytesRead=" + bytesRead + " 2nd record (record 1):" + new String(recBuf, ZUtil.getDefaultPlatformEncoding()));
            dsnFile.seek(0L, 0);
            bytesRead = dsnFile.read(recBuf);
            System.out.println("bytesRead=" + bytesRead + " 1st record (record 0):" + new String(recBuf, ZUtil.getDefaultPlatformEncoding()));
            dsnFile.seek(5L, 0);
            bytesRead = dsnFile.read(recBuf);
            System.out.println("bytesRead=" + bytesRead + " 6th record (record 5):" + new String(recBuf, ZUtil.getDefaultPlatformEncoding()));
            dsnFile.rewind();
            bytesRead = dsnFile.read(recBuf);
            while (bytesRead != -1) {
                System.out.println("bytesRead=" + bytesRead + " data:" + new String(recBuf, ZUtil.getDefaultPlatformEncoding()));
                bytesRead = dsnFile.read(recBuf);
            }
        }
        catch (Exception e) {
            System.out.println("Unable to randomly access " + fileName);
            e.printStackTrace();
        }
        finally {
            try {
                if (dsnFile != null) {
                    dsnFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void usage() {
        System.out.println("RandomAccessFile -- Demonstrates how to randomly access a file.");
        System.out.println("Usage:");
        System.out.println("\tjava com.ibm.jzos.sample.nonvsam.file.RandomAccessFile fileName");
        System.out.println("\tfileName: The name of the file to access");
        System.out.println("\t\tExample fileName");
        System.out.println("\t\t\tPS Dataset: //'USERID.PRIVATE.SAMPLE'");
        System.out.println("\t\t\tPDS Member: //'USERID.PRIVATE.PDS(SAMPLE)'");
        System.out.println();
        System.exit(0);
    }
}

