/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.nonvsam.file;

import com.ibm.jzos.ZFile;

public class CreateFileWithFileAttributes {
    public static void main(String[] args) {
        if (args.length != 1) {
            CreateFileWithFileAttributes.usage();
        }
        String fileName = args[0];
        CreateFileWithFileAttributes.createFileWithAttributes(fileName);
    }

    public static void createFileWithAttributes(String fileName) {
        try {
            String dsn = ZFile.getFullyQualifiedDSN((String)fileName);
            String targetDD = ZFile.allocDummyDDName();
            ZFile.bpxwdyn((String)("alloc fi(" + targetDD + ") da(" + dsn + ") reuse new dsorg(ps) lrecl(1028) recfm(v,b) tracks space(1,1) blksize(6144) catalog msg(wtp)"));
            ZFile.bpxwdyn((String)("free fi(" + targetDD + ") msg(wtp)"));
            if (ZFile.exists((String)fileName)) {
                System.out.println("File " + fileName + " was successfully created");
            } else {
                System.out.println("File " + fileName + " cannot be created");
            }
        }
        catch (Exception e) {
            System.out.println("Failed to create " + fileName + ":");
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("CreateFileWithFileAttributes -- Demonstrates how to create a non-VSAM MVS sequential dataset with specific file attributes.");
        System.out.println("Usage:");
        System.out.println("\tjava com.ibm.jzos.sample.nonvsam.file.CreateFileWithFileAttributes fileName");
        System.out.println("\tfileName: The name of the file to create");
        System.out.println("\t\tExample fileName");
        System.out.println("\t\tPS Dataset: //PRIVATE.SAMPLE or //'USERID.PRIVATE.SAMPLE'");
        System.out.println();
        System.exit(0);
    }
}

