/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.nonvsam.directory;

import com.ibm.jzos.ZFile;

public class MakeDirectoryLike {
    public static void main(String[] args) {
        if (args.length != 2) {
            MakeDirectoryLike.usage();
        }
        String newDirname = args[0];
        String modelDirName = args[1];
        MakeDirectoryLike.makeDirectoryLike(newDirname, modelDirName);
    }

    public static void makeDirectoryLike(String newDirname, String modelDirname) {
        try {
            if (modelDirname.startsWith("//") && newDirname.startsWith("//")) {
                String targetDD = ZFile.allocDummyDDName();
                String sourceDSN = ZFile.getFullyQualifiedDSN((String)modelDirname);
                String targetDSN = ZFile.getFullyQualifiedDSN((String)newDirname);
                ZFile.bpxwdyn((String)("alloc fi(" + targetDD + ") da(" + targetDSN + ") like(" + sourceDSN + ") reuse new catalog msg(wtp)"));
                ZFile.bpxwdyn((String)("free fi(" + targetDD + ") msg(wtp)"));
                if (ZFile.exists((String)newDirname)) {
                    System.out.println("Directory " + newDirname + " was successfully created.");
                } else {
                    System.out.println("Directory " + newDirname + " cannot be created. Possibly invalid file name or inadequate authority.");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Failed to create " + newDirname);
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("MakeDirectoryLike -- Demonstrates how to create a directory using the attributes of an existing directory.");
        System.out.println("Usage:");
        System.out.println("\tjava com.ibm.jzos.sample.nonvsam.directory.MakeDirectoryLike newDirectoryName modelDirectoryName");
        System.out.println("\tnewDirectoryName: The name of the directory to create");
        System.out.println("\tmodelDirectoryName: The name of an existing directory to use as a model");
        System.out.println("\tBoth directory names must use the same format");
        System.out.println("\t\tExample newDirectoryName, modelDirectoryName");
        System.out.println("\t\t\tPDS Directory: //PRIVATE.PDS or //'USERID.PRIVATE.PDS'");
        System.out.println();
        System.exit(0);
    }
}

