/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.nonvsam.directory;

import com.ibm.jzos.ZFile;
import java.io.File;

public class DeleteDirectory {
    public static void main(String[] args) {
        if (args.length != 1) {
            DeleteDirectory.usage();
        }
        String dirName = args[0];
        DeleteDirectory.deleteDirectory(dirName);
    }

    private static void deleteDirectory(String dirName) {
        try {
            if (dirName.startsWith("//")) {
                if (ZFile.exists((String)dirName)) {
                    ZFile.remove((String)dirName);
                    System.out.println("Directory " + dirName + " was successfully deleted.");
                } else {
                    System.out.println("Directory " + dirName + " does not exist.");
                }
            } else {
                File dir = new File(dirName);
                if (dir.exists()) {
                    if (dir.delete()) {
                        System.out.println("Directory " + dirName + " was successfully deleted.");
                    } else {
                        System.out.println("Directory " + dirName + " cannot be deleted. Possibly invalid directory name, inadequate authority, or the directory is not empty.");
                    }
                } else {
                    System.out.println("Directory " + dirName + " does not exist.");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Failed to delete the directory " + dirName + ":");
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("DeleteDirectory -- Demonstrates how to delete a directory.");
        System.out.println("Usage:");
        System.out.println("\tjava com.ibm.jzos.sample.nonvsam.directory.DeleteDirectory directoryName");
        System.out.println("\tdirectoryName: The name of the directory to delete");
        System.out.println("\t\tExample directoryName");
        System.out.println("\t\t\tHFS Directory: /tmp/USERID/hfsdir");
        System.out.println("\t\t\tPDS Directory: //PRIVATE.PDS or //'USERID.PRIVATE.PDS'");
        System.out.println();
        System.exit(0);
    }
}

