/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.dfsort;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;

public class DsInfo {
    private String dsn;
    private String fullyQualifiedDsn;
    private String zFileDsn;
    private int recfmBits;
    private int lrecl;

    public DsInfo(String dsn) throws ZFileException {
        this.dsn = dsn;
        this.fullyQualifiedDsn = ZFile.getFullyQualifiedDSN((String)dsn);
        this.zFileDsn = ZFile.getSlashSlashQuotedDSN((String)dsn);
        if (!ZFile.dsExists((String)this.zFileDsn)) {
            throw new RuntimeException("Dataset " + this.fullyQualifiedDsn + " does not exist.");
        }
        try (ZFile zfile = new ZFile(this.zFileDsn, "rb,type=record");){
            this.recfmBits = zfile.getRecfmBits();
            this.lrecl = zfile.getLrecl();
        }
    }

    public String getDsn() {
        return this.dsn;
    }

    public String getFullyQualifiedDsn() {
        return this.fullyQualifiedDsn;
    }

    public String getZFileDsn() {
        return this.zFileDsn;
    }

    public int getLrecl() {
        return this.lrecl;
    }

    public boolean isFixedRecfm() {
        return (1 & this.recfmBits) != 0;
    }

    public boolean isVariableRecfm() {
        return (2 & this.recfmBits) != 0;
    }
}

