/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.dfsort;

import com.ibm.jzos.DfSort;
import com.ibm.jzos.RDWInputRecordStream;
import com.ibm.jzos.RcException;
import com.ibm.jzos.sample.dfsort.DfSortArguments;
import com.ibm.jzos.sample.dfsort.DsInfo;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

public class DfSortVariableDatasetToJava {
    public static void main(String[] args) throws Exception {
        DsInfo inDs;
        DfSortArguments dfsortArgs = new DfSortArguments(args);
        if (dfsortArgs.getSortinDataset() == null) {
            System.err.println("Usage: " + DfSortVariableDatasetToJava.class.getName() + " sortin=<dsn> [encoding=<codepage>] [shareas=<yes|NO>]");
            System.err.println("Where:");
            System.err.println("\tsortin is a RECFM=F dataset");
            System.err.println("\tencoding is the source character set.  If not supplied, binary data is assumed.");
            System.err.println("\tshareas = yes: DFSORT executes in the same address space as the JVM");
            System.exit(4);
        }
        if (!(inDs = dfsortArgs.getSortinDataset()).isVariableRecfm()) {
            System.err.println("Dataset " + inDs.getFullyQualifiedDsn() + " is not RECFM=V");
            System.exit(8);
        }
        DfSortVariableDatasetToJava.doSort(dfsortArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSort(DfSortArguments dfsortArgs) throws Exception {
        DsInfo inDs = dfsortArgs.getSortinDataset();
        DfSort dfSort = new DfSort();
        if (dfsortArgs.getLogLevel() != -1) {
            dfSort.setLoggingLevel(dfsortArgs.getLogLevel());
        }
        dfSort.addAllocation("alloc fi(sortin) da(" + inDs.getFullyQualifiedDsn() + ") reuse shr msg(2)");
        dfSort.setOutputStreamHasRdws();
        dfSort.addControlStatement("OPTION VLSHRT");
        dfSort.addControlStatement("SORT FIELDS=(5,25,CH,A)");
        dfSort.setSameAddressSpace(dfsortArgs.isSameAddressSpace());
        long startTime = System.currentTimeMillis();
        dfSort.execute();
        RDWInputRecordStream rdwis = new RDWInputRecordStream((InputStream)new BufferedInputStream(dfSort.getChildStdoutStream()));
        int recordCount = 0;
        byte[] record = new byte[inDs.getLrecl()];
        int recLen = 0;
        try {
            while ((recLen = rdwis.read(record)) != -1) {
                if (dfsortArgs.getEncoding() != null) {
                    String string = new String(record, 0, recLen, dfsortArgs.getEncoding());
                }
                ++recordCount;
            }
        }
        finally {
            rdwis.close();
        }
        int rc = 0;
        try {
            rc = dfSort.getReturnCode();
        }
        catch (RcException rce) {
            System.out.println("Caught RcException: " + rce.getMessage());
            rc = -1;
        }
        long runtime = System.currentTimeMillis() - startTime;
        if (rc != 0 || dfsortArgs.getLogLevel() >= 0) {
            List stderrLines = dfSort.getStderrLines();
            Iterator i = stderrLines.iterator();
            while (i.hasNext()) {
                System.err.println(i.next());
            }
        }
        System.out.println("RC=" + rc + " TIME=" + runtime + " RECORD COUNT=" + recordCount + " " + DfSortVariableDatasetToJava.class.getName());
    }
}

