/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.dfsort;

import com.ibm.jzos.DfSort;
import com.ibm.jzos.RcException;
import com.ibm.jzos.sample.dfsort.DfSortArguments;
import com.ibm.jzos.sample.dfsort.DsInfo;
import java.io.BufferedOutputStream;
import java.util.Iterator;
import java.util.List;

public class DfSortFixedJavaToDataset {
    private static final String RECORD_DATA = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static void main(String[] args) throws Exception {
        DsInfo outDs;
        DfSortArguments dfsortArgs = new DfSortArguments(args);
        if (dfsortArgs.getSortoutDataset() == null || dfsortArgs.getNumrecs() < 0) {
            System.err.println("Usage: " + DfSortFixedJavaToDataset.class.getName() + " sortout=<dsn> numrecs=<nn> [shareas=<yes|NO>]");
            System.err.println("\tsortout is an existing RECFM=F DSN to hold DFSORT output");
            System.err.println("\tnumrecs is the number of records to generate");
            System.err.println("\tshareas = yes: DFSORT executes in the same address space as the JVM");
            System.exit(4);
        }
        if (!(outDs = dfsortArgs.getSortoutDataset()).isFixedRecfm()) {
            System.err.println("Dataset " + outDs.getFullyQualifiedDsn() + " is not RECFM=F");
            System.exit(8);
        }
        DfSortFixedJavaToDataset.doSort(dfsortArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSort(DfSortArguments dfsortArgs) throws Exception {
        DsInfo outDs = dfsortArgs.getSortoutDataset();
        DfSort dfSort = new DfSort();
        if (dfsortArgs.getLogLevel() != -1) {
            dfSort.setLoggingLevel(dfsortArgs.getLogLevel());
        }
        dfSort.setInputStreamRecLen(outDs.getLrecl());
        dfSort.addAllocation("alloc fi(sortout) da('" + outDs.getFullyQualifiedDsn() + "') reuse shr msg(2)");
        dfSort.addControlStatement("SORT FIELDS=(1," + outDs.getLrecl() + ",CH,A)");
        dfSort.addControlStatement("RECORD TYPE=F,LENGTH=(" + outDs.getLrecl() + ")");
        dfSort.setSameAddressSpace(dfsortArgs.isSameAddressSpace());
        long startTime = System.currentTimeMillis();
        dfSort.execute();
        BufferedOutputStream bos = new BufferedOutputStream(dfSort.getChildStdinStream());
        byte[] byte_data = RECORD_DATA.getBytes();
        byte[] record = new byte[outDs.getLrecl()];
        try {
            for (int i = 0; i < dfsortArgs.getNumrecs(); ++i) {
                int s = i % (byte_data.length - 1);
                int j = 0;
                while (j < record.length) {
                    record[j] = byte_data[s % (byte_data.length - 1)];
                    ++j;
                    ++s;
                }
                bos.write(record);
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        finally {
            bos.close();
        }
        int rc = 0;
        try {
            rc = dfSort.getReturnCode();
        }
        catch (RcException rce) {
            System.out.println("Caught RcException: " + rce.getMessage());
            rc = -1;
        }
        long runtime = System.currentTimeMillis() - startTime;
        if (rc != 0 || dfsortArgs.getLogLevel() >= 0) {
            List stderrLines = dfSort.getStderrLines();
            Iterator i = stderrLines.iterator();
            while (i.hasNext()) {
                System.err.println(i.next());
            }
        }
        System.out.println("RC=" + rc + " TIME=" + runtime + " RECORD COUNT=" + dfsortArgs.getNumrecs() + " " + DfSortFixedJavaToDataset.class.getName());
    }
}

