/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.dfsort;

import com.ibm.jzos.DfSort;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.sample.dfsort.DfSortArguments;
import com.ibm.jzos.sample.dfsort.DsInfo;
import java.util.Iterator;
import java.util.List;

public class DfSortCopyFixedDataset {
    public static void main(String[] args) throws Exception {
        DfSortArguments dfsortArgs = new DfSortArguments(args);
        if (dfsortArgs.getSortinDataset() == null || dfsortArgs.getSortoutDataset() == null) {
            System.err.println("Usage: " + DfSortCopyFixedDataset.class.getName() + " sortin=<dsn> sortout=<dsn> [shareas=<yes|NO>]");
            System.err.println("Where:");
            System.err.println("\tsortin is a RECFM=F dataset");
            System.err.println("\tsortout is a RECFM=F dataset");
            System.err.println("\tshareas = yes: DFSORT executes in the same address space as the JVM");
            System.exit(4);
        }
        DsInfo inDs = dfsortArgs.getSortinDataset();
        DsInfo outDs = dfsortArgs.getSortoutDataset();
        if (!inDs.isFixedRecfm()) {
            System.err.println("Dataset " + inDs.getFullyQualifiedDsn() + " is not RECFM=F");
            System.exit(8);
        }
        if (!outDs.isFixedRecfm()) {
            System.err.println("Dataset " + outDs.getFullyQualifiedDsn() + " is not RECFM=F");
            System.exit(8);
        }
        if (inDs.getLrecl() != outDs.getLrecl()) {
            System.err.println("Dataset " + inDs.getFullyQualifiedDsn() + " (" + inDs.getLrecl() + ") and " + outDs.getFullyQualifiedDsn() + " (" + outDs.getLrecl() + ")  do not have the same LRECL");
            System.exit(8);
        }
        DfSortCopyFixedDataset.doSort(dfsortArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSort(DfSortArguments dfsortArgs) throws Exception {
        DsInfo inDs = dfsortArgs.getSortinDataset();
        DsInfo outDs = dfsortArgs.getSortoutDataset();
        DfSort dfSort = new DfSort();
        if (dfsortArgs.getLogLevel() != -1) {
            dfSort.setLoggingLevel(dfsortArgs.getLogLevel());
        }
        dfSort.addAllocation("alloc fi(sortin) da(" + inDs.getFullyQualifiedDsn() + ") reuse shr msg(2)");
        dfSort.addAllocation("alloc fi(sortout) da(" + outDs.getFullyQualifiedDsn() + ") reuse shr msg(2)");
        dfSort.addControlStatement("SORT FIELDS=COPY");
        dfSort.setSameAddressSpace(dfsortArgs.isSameAddressSpace());
        long startTime = System.currentTimeMillis();
        dfSort.execute();
        int rc = 0;
        try {
            rc = dfSort.getReturnCode();
        }
        catch (RcException rce) {
            System.out.println("Caught RcException: " + rce.getMessage());
            rc = -1;
        }
        long dfsortRuntime = System.currentTimeMillis() - startTime;
        if (rc != 0 || dfsortArgs.getLogLevel() >= 0) {
            List stderrLines = dfSort.getStderrLines();
            Iterator i = stderrLines.iterator();
            while (i.hasNext()) {
                System.err.println(i.next());
            }
        }
        startTime = System.currentTimeMillis();
        ZFile zFileIn = new ZFile(inDs.getZFileDsn(), "rb,type=record,noseek");
        ZFile zFileOut = new ZFile(outDs.getZFileDsn(), "wb,type=record,noseek");
        long recordCount = 0L;
        try {
            int nRead;
            byte[] recBuf = new byte[zFileIn.getLrecl()];
            while ((nRead = zFileIn.read(recBuf)) >= 0) {
                zFileOut.write(recBuf, 0, nRead);
                ++recordCount;
            }
        }
        finally {
            zFileIn.close();
            zFileOut.close();
        }
        long zfileRuntime = System.currentTimeMillis() - startTime;
        System.out.println("RC=" + rc + " DFSORT_TIME=" + dfsortRuntime + " ZFILE_TIME=" + zfileRuntime + " RECORD COUNT=" + recordCount + " " + DfSortCopyFixedDataset.class.getName());
    }
}

