/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.compress;

import com.ibm.jzos.CompressionFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class ExpandFile {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: com.ibm.jzos.sample.compress.ExpandFile infile outfile");
            System.err.println("   Note: System property com.ibm.jzos.compression.type may be used to configure compression type");
            System.exit(8);
        }
        String fnIn = args[0];
        String fnOut = args[1];
        CompressionFactory factory = null;
        InputStream input = null;
        OutputStream output = null;
        try {
            int nRead;
            factory = CompressionFactory.getDefault();
            input = factory.getExpandingInputStream((InputStream)new FileInputStream(fnIn));
            System.out.println("Using: " + String.valueOf(input.getClass()));
            output = new FileOutputStream(fnOut);
            byte[] buf = new byte[16384];
            long time = System.currentTimeMillis();
            long totalExpanded = 0L;
            while ((nRead = input.read(buf)) >= 0) {
                output.write(buf, 0, nRead);
                totalExpanded += (long)nRead;
            }
            input.close();
            output.close();
            float secs = System.currentTimeMillis() - time;
            System.out.println("Expanded " + new File(fnIn).length() + "->" + totalExpanded + " bytes in " + (secs /= 1000.0f) + " seconds");
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable throwable) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (Throwable throwable) {}
            }
            if (factory != null) {
                factory.release();
            }
        }
    }
}

