/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.sample.ZipDatasetSource;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipOutputStream;

public class ZipDatasets {
    public static final String DEFAULT_TARGET_ENCODING = "ISO8859-1";
    private String outFileName;
    private String[] indsnames;
    private String targetEncoding;
    private int errors = 0;

    public static void usage() {
        System.err.println("Usage: com.ibm.jzos.sample.ZipDatasets [-t targetEncoding] outfile indsname...");
        System.err.println("  where:  ");
        System.err.println("  -t targetEncoding can optionally specify the codepage name to encode the");
        System.err.println("      text data as it is written to the Zip file.  If not specified,");
        System.err.println("      this defaults to ISO8859-1 (Latin/ASCII)");
        System.err.println("  and outfile is either:");
        System.err.println("    - a Unix file path name: /path/to/some/file.zip");
        System.err.println("    - a dataset name:  //A.B.C");
        System.err.println("    - a PDS member name:  //A.B.C(MEM)");
        System.err.println("    - a DD name: //DD:XYZ");
        System.err.println("    - a DD name and member:  //DD:XYZ(MEM)");
        System.err.println("  and each (at least one) indsname is either:");
        System.err.println("    - a dataset name:  //A.B.C");
        System.err.println("    - a dataset pattern:  //A.*.D");
        System.err.println("    - a PDS member name:  //A.B.C(MEM)");
        System.err.println("    - a PDS member pattern:  //A.B.C(D*X)");
        System.err.println("    - a DD name: //DD:XYZ");
        System.err.println("    - a DD name and member:  //DD:XYZ(MEM)");
        System.err.println("    - a DD name and member pattern:  //DD:XYZ(D*X)");
        System.err.println("  \"//\" prefixes may be omitted from indsnames");
        System.err.println("  All dataset names are assumed to be fully qualified.");
    }

    public static void main(String[] args) throws Exception {
        int errors;
        String targetEncoding = null;
        int iOutfileName = 0;
        if (args == null || args.length < 2) {
            ZipDatasets.usage();
            System.exit(12);
        }
        if (args[0].equals("-t")) {
            targetEncoding = args[1];
            iOutfileName = 2;
        }
        if (args.length < iOutfileName + 2) {
            ZipDatasets.usage();
            System.exit(12);
        }
        String[] indsnames = new String[args.length - iOutfileName - 1];
        System.arraycopy(args, iOutfileName + 1, indsnames, 0, indsnames.length);
        ZipDatasets instance = new ZipDatasets(args[iOutfileName], indsnames);
        if (targetEncoding != null) {
            instance.setTargetEncoding(targetEncoding);
        }
        if ((errors = instance.run()) > 0) {
            System.exit(8);
        }
    }

    public ZipDatasets(String outFileName, String[] indsnames) {
        this.outFileName = outFileName;
        this.indsnames = indsnames;
        this.targetEncoding = DEFAULT_TARGET_ENCODING;
    }

    public void setTargetEncoding(String targetEncoding) {
        this.targetEncoding = targetEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() throws IOException {
        ZipOutputStream zipOutStream = this.openZipOutputStream();
        try {
            this.processInputFiles(zipOutStream);
            zipOutStream.finish();
            System.out.println("   done: " + this.errors + " errors");
            int n = this.errors;
            return n;
        }
        finally {
            try {
                zipOutStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private ZipOutputStream openZipOutputStream() throws IOException {
        OutputStream os = this.outFileName.startsWith("//") ? this.openDataset(this.outFileName) : new FileOutputStream(this.outFileName);
        return new ZipOutputStream(os);
    }

    private OutputStream openDataset(String name) throws IOException {
        ZFile zfile = new ZFile(ZFile.getSlashSlashQuotedDSN((String)name, (boolean)true), "wb,recfm=vb,lrecl=1028,blksize=0");
        return zfile.getOutputStream();
    }

    private void processInputFiles(ZipOutputStream zipOutStream) {
        for (int i = 0; i < this.indsnames.length; ++i) {
            String inputName = this.indsnames[i];
            ZipDatasetSource source = new ZipDatasetSource(inputName);
            try {
                source.addTo(zipOutStream, this.targetEncoding);
                continue;
            }
            catch (Throwable t) {
                ++this.errors;
                try {
                    zipOutStream.closeEntry();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                System.out.println(">>> Error occuring processing input dataset: " + inputName);
                System.err.println(">>> Error occuring processing input dataset: " + inputName);
                t.printStackTrace();
            }
        }
    }
}

