/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample;

import com.ibm.jzos.MvsCommandCallback;
import com.ibm.jzos.MvsConsole;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;

public class MvsConsoleWrapper {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: com.ibm.jzos.sample.MvsConsoleWrapper <class> <args>...");
            System.exit(8);
        }
        MvsConsoleWrapper.redirectSystemOut();
        MvsConsoleWrapper.redirectSystemIn();
        MvsConsoleWrapper.invokeMain(args);
    }

    static void redirectSystemOut() throws Exception {
        PipedOutputStream pos = new PipedOutputStream();
        PrintStream ps = new PrintStream(pos);
        PipedInputStream pis = new PipedInputStream(pos);
        final BufferedReader reader = new BufferedReader(new InputStreamReader(pis));
        new Thread(){

            @Override
            public void run() {
                try {
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        MvsConsole.wto((String)line, (int)64, (int)1024);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
        System.setOut(ps);
    }

    static void redirectSystemIn() throws Exception {
        if (!MvsConsole.isListening()) {
            MvsConsole.startMvsCommandListener();
        }
        PipedOutputStream pos = new PipedOutputStream();
        final OutputStreamWriter writer = new OutputStreamWriter(pos);
        MvsConsole.registerMvsCommandCallback((MvsCommandCallback)new MvsCommandCallback(){

            public void handleStart(String parms) {
            }

            public void handleModify(String cmd) {
                try {
                    writer.write(cmd + "\n");
                    writer.flush();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }

            public boolean handleStop() {
                return true;
            }
        });
        PipedInputStream pis = new PipedInputStream(pos);
        System.setIn(pis);
    }

    static void invokeMain(String[] args) throws Exception {
        String[] mainArgs = new String[args.length - 1];
        System.arraycopy(args, 1, mainArgs, 0, mainArgs.length);
        Class<?> mainClass = Class.forName(args[0]);
        Method mainMethod = mainClass.getMethod("main", String[].class);
        mainMethod.invoke(mainClass, new Object[]{mainArgs});
    }
}

