/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample;

import com.ibm.jzos.MvsCommandCallback;
import com.ibm.jzos.MvsConsole;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import com.ibm.jzos.ZUtil;

public class MvsConsoleInteraction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processDataset(String dsn) throws ZFileException {
        String fqDsn = ZFile.getSlashSlashQuotedDSN((String)dsn);
        if (!ZFile.exists((String)fqDsn)) {
            MvsConsole.wto((String)("Dataset " + dsn + " does not exist."), (int)32, (int)16);
            return false;
        }
        ZFile zFile = new ZFile(fqDsn, "rb,type=record,noseek");
        long count = 0L;
        long byteCount = 0L;
        try {
            int nRead;
            byte[] recBuf = new byte[zFile.getLrecl()];
            while ((nRead = zFile.read(recBuf)) > 0) {
                byteCount += (long)nRead;
                ++count;
            }
            MvsConsole.wto((String)("Processed " + byteCount + " bytes and " + count + " records in " + zFile.getActualFilename()), (int)32, (int)16);
        }
        finally {
            zFile.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        MyMvsCommandCallback mvsCallback = new MyMvsCommandCallback();
        if (!MvsConsole.isListening()) {
            MvsConsole.startMvsCommandListener();
        }
        MvsConsole.registerMvsCommandCallback((MvsCommandCallback)mvsCallback);
        System.out.println("Check system console for messages.");
        String jobname = ZUtil.getCurrentJobname();
        while (true) {
            MvsConsole.wto((String)("Java console interaction:\n   f " + jobname + ",APPL=(DSN | EXIT)\n   p " + jobname), (int)32, (int)16);
            MyMvsCommandCallback myMvsCommandCallback = mvsCallback;
            synchronized (myMvsCommandCallback) {
                mvsCallback.wait();
            }
            if ("EXIT".equalsIgnoreCase(mvsCallback.modifyCommand)) break;
            if (!MvsConsoleInteraction.processDataset(mvsCallback.modifyCommand)) continue;
            ++mvsCallback.datasetCount;
        }
        MvsConsole.wto((String)("EXIT modify command received.  Processed " + mvsCallback.datasetCount + " dataset(s)"), (int)32, (int)16);
        System.out.println("Finished processing.");
    }

    static class MyMvsCommandCallback
    implements MvsCommandCallback {
        public String modifyCommand = null;
        public String startParameters = null;
        public int datasetCount = 0;

        MyMvsCommandCallback() {
        }

        public synchronized void handleModify(String modifyCommand) {
            this.modifyCommand = modifyCommand;
            this.notify();
        }

        public void handleStart(String startParameters) {
            this.startParameters = startParameters;
            MvsConsole.wto((String)("START command received.  Parameters=" + startParameters != null ? startParameters : "<NONE>"), (int)32, (int)16);
        }

        public boolean handleStop() {
            MvsConsole.wto((String)("STOP command received.  Processed " + this.datasetCount + " dataset(s)"), (int)32, (int)16);
            System.out.println("Finished processing.");
            return true;
        }
    }
}

