/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.vsam.file;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;

public class DeleteKsdsRecords {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            DeleteKsdsRecords.usage();
        }
        String fileName = args[0];
        DeleteKsdsRecords.deleteRecords(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteRecords(String fileName) throws Exception {
        String options = "ab+,type=record";
        ZFile zfile = new ZFile(fileName, options);
        int lrecl = zfile.getLrecl();
        byte[] recBuf = new byte[lrecl];
        byte[] ignoreKey = " ".getBytes("IBM-1047");
        byte[] key = "30000003".getBytes("IBM-1047");
        try {
            DeleteKsdsRecords.check("Locate LAST", zfile.locate(ignoreKey, 2));
            zfile.read(recBuf);
            zfile.delrec();
            DeleteKsdsRecords.check("Locate Key 30000003", zfile.locate(key, 3));
            zfile.read(recBuf);
            zfile.delrec();
            DeleteKsdsRecords.check("Locate FIRST", zfile.locate(ignoreKey, 1));
            while (zfile.read(recBuf) != -1) {
                zfile.delrec();
            }
            try {
                zfile.delrec();
                DeleteKsdsRecords.check("Expected exception from delrec()", false);
            }
            catch (ZFileException zfe) {
                System.out.println("Expected exception: " + String.valueOf((Object)zfe));
                DeleteKsdsRecords.check("zfe.getErrno=" + zfe.getErrno(), 76 == zfe.getErrno());
            }
            DeleteKsdsRecords.check("Locate key 30000003 after deleting", !zfile.locate(key, 3));
        }
        finally {
            zfile.close();
        }
    }

    static void check(String msg, boolean value) {
        if (!value) {
            throw new RuntimeException(msg);
        }
    }

    private static void usage() {
        System.out.println("DeleteKsdsRecords - Demonstrates how to delete records from a VSAM dataset.");
        System.out.println("Usage:");
        System.out.println("\tjava com.ibm.jzos.sample.vsam.file.DeleteKsdsRecords file");
        System.out.println("\tfile: The name of the VSAM dataset containing the records to delete");
        System.out.println("\t\tExample file");
        System.out.println("\t\tVSAM Dataset: //'TSOUSER.PRIVATE.JZOS.SAMPLES.KSDS'");
        System.out.println();
        System.exit(0);
    }
}

