/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.vsam.cluster;

import com.ibm.jzos.AccessMethodServices;
import com.ibm.jzos.ZFile;

public class DefineKsdsCluster {
    public static final String VSAM_VOLUME = "PRV000";

    public static void main(String[] args) {
        if (args.length != 1) {
            DefineKsdsCluster.usage();
        }
        String dsName = args[0];
        DefineKsdsCluster.defineCluster(ZFile.getFullyQualifiedDSN((String)dsName));
    }

    public static void defineCluster(String dsname) {
        try {
            System.out.println("dsName: " + dsname);
            if (dsname.startsWith("//")) {
                dsname = dsname.substring(2);
            }
            dsname = dsname.toUpperCase();
            String def1 = "DEFINE CLUSTER (NAME(";
            def1 = def1.concat(dsname).concat(") -");
            String def2 = "VOLUMES(";
            def2 = def2.concat(VSAM_VOLUME).concat(")) - ");
            String def3 = "DATA (NAME(";
            def3 = def3.concat(dsname).concat(".DATA)) - ");
            String def4 = "INDEX (NAME(";
            def4 = def4.concat(dsname).concat(".INDEX))");
            AccessMethodServices ams = new AccessMethodServices();
            ams.addInputLine(def1);
            ams.addInputLine("INDEXED NOREUSE -");
            ams.addInputLine("TRK(4 4) RECSZ(80 80) KEYS(8 0) - ");
            ams.addInputLine(def2);
            ams.addInputLine(def3);
            ams.addInputLine(def4);
            int rc = ams.execute();
            String out = ams.getOutputLines();
            System.out.println("IDCAMS return code: " + rc);
            System.out.println("IDCAMS return text: " + out);
        }
        catch (Exception e) {
            System.out.println("Failed to create VSAM: Exception caught: ");
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("DefineKsdsCluster -- Define a VSAM KSDS Cluster.");
        System.out.println("Usage:");
        System.out.println("\tjava com.ibm.jzos.sample.vsam.cluster.DefineKsdsCluster dsName");
        System.out.println("\tdsName: The fully qualified dataset name");
        System.out.println("\t\tExample dsName:");
        System.out.println("\t\t//'TSOUSER.PRIVATE.JZOS.SAMPLES.KSDS'");
        System.out.println("\t\t    creates //'TSOUSER.PRIVATE.JZOS.SAMPLES.KSDS'");
        System.out.println("\t\t            //'TSOUSER.PRIVATE.JZOS.SAMPLES.KSDS.DATA'");
        System.out.println("\t\t            //'TSOUSER.PRIVATE.JZOS.SAMPLES.KSDS.INDEX'");
        System.exit(0);
    }
}

