/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.nonvsam.file;

import com.ibm.jzos.ZFile;

public class CreateFileLike {
    public static void main(String[] args) {
        if (args.length != 2) {
            CreateFileLike.usage();
        }
        String newFilename = args[0];
        String modelFileName = args[1];
        CreateFileLike.create(newFilename, modelFileName);
    }

    public static void create(String newFilename, String modelFilename) {
        try {
            String targetDD = ZFile.allocDummyDDName();
            String sourceDSN = ZFile.getFullyQualifiedDSN((String)modelFilename);
            String targetDSN = ZFile.getFullyQualifiedDSN((String)newFilename);
            ZFile.bpxwdyn((String)("alloc fi(" + targetDD + ") da(" + targetDSN + ") like(" + sourceDSN + ") reuse new catalog msg(wtp)"));
            ZFile.bpxwdyn((String)("free fi(" + targetDD + ") msg(wtp)"));
            if (ZFile.exists((String)newFilename)) {
                System.out.println("File " + newFilename + " was successfully created.");
            } else {
                System.out.println("File " + newFilename + " cannot be created. Possibly invalid file name or inadequate authority.");
            }
        }
        catch (Exception e) {
            System.out.println("Failed to create " + newFilename);
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("CreateFileLike -- Demonstrates how to create a file using the attributes of an existing file.");
        System.out.println("Usage:");
        System.out.println("\tjava com.ibm.jzos.sample.nonvsam.file.CreateFileLike newFileName modelFileName");
        System.out.println("\tnewFileName: The name of the file to create");
        System.out.println("\tmodelFileName: The name of an existing file to use as a model");
        System.out.println("\tBoth file names must use the same format");
        System.out.println("\t\tExample newFileName, modelFileName");
        System.out.println("\t\t\tPS Dataset: //'USERID.PRIVATE.SAMPLE'");
        System.out.println();
        System.exit(0);
    }
}

