/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.nonvsam.file;

import com.ibm.jzos.ZFile;

public class CopyFile {
    public static void main(String[] args) {
        if (args.length != 2) {
            CopyFile.usage();
        }
        String source = args[0];
        String destination = args[1];
        CopyFile.copy(source, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String source, String destination) {
        ZFile fileIn = null;
        ZFile fileOut = null;
        try {
            if (ZFile.exists((String)source)) {
                fileIn = new ZFile(source, "rb,type=record,noseek");
                if (ZFile.exists((String)destination)) {
                    fileOut = new ZFile(destination, "r+b,type=record,noseek");
                    byte[] buf = new byte[fileOut.getLrecl()];
                    while (fileOut.read(buf) != -1) {
                    }
                    fileOut.flush();
                } else {
                    fileOut = new ZFile(destination, "wb,type=record,noseek");
                }
                int length = 0;
                long count = 0L;
                byte[] recBuf = new byte[fileIn.getLrecl()];
                while ((length = fileIn.read(recBuf)) >= 0) {
                    fileOut.write(recBuf, 0, length);
                    ++count;
                }
                System.out.println(count + " records copied");
            } else {
                System.out.println("Source file " + source + " does not exist.");
            }
        }
        catch (Exception e) {
            System.out.println("Failed to copy " + source + " to " + destination);
            e.printStackTrace();
        }
        finally {
            try {
                if (fileIn != null) {
                    fileIn.close();
                }
                if (fileOut != null) {
                    fileOut.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static void usage() {
        System.out.println("CopyFile -- Demonstrates how to copy data from one file to another");
        System.out.println("Usage:");
        System.out.println("\tjava com.ibm.jzos.sample.nonvsam.file.CopyFile source destination");
        System.out.println("\tsource: The name of the file to read from");
        System.out.println("\tdestination: The name of the file to write to");
        System.out.println("\t\tExamples");
        System.out.println("\t\tPS Dataset: //'USERID.PRIVATE.PS'");
        System.out.println("\t\tPDS Member: //'USERID.PRIVATE.PDS(MEMBER)'");
        System.out.println();
        System.exit(0);
    }
}

