/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.nonvsam.directory;

import com.ibm.jzos.ZFile;
import java.io.File;

public class MakeDirectory {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            MakeDirectory.usage();
        }
        String dirName = args[0];
        MakeDirectory.makeDirectory(dirName);
    }

    private static void makeDirectory(String dirName) throws Exception {
        try {
            if (dirName.startsWith("//")) {
                if (ZFile.exists((String)dirName)) {
                    System.out.println("Directory " + dirName + " already exists.");
                } else {
                    String dsn = ZFile.getFullyQualifiedDSN((String)dirName);
                    String ddname = ZFile.allocDummyDDName();
                    ZFile.bpxwdyn((String)("alloc fi(" + ddname + ") da(" + dsn + ") reuse new space(10,5) cyl blksize(6160) dir(10) catalog lrecl(80) recfm(f,b) msg(wtp)"));
                    ZFile.bpxwdyn((String)("free fi(" + ddname + ") msg(wtp)"));
                    if (ZFile.exists((String)dirName)) {
                        System.out.println("Directory " + dirName + " was successfully created");
                    } else {
                        System.out.println("Directory " + dirName + " cannot be created");
                    }
                }
            } else {
                File dir = new File(dirName);
                if (!dir.exists()) {
                    if (dir.mkdir()) {
                        System.out.println("Directory " + dirName + " was successfully created.");
                    } else {
                        System.out.println("Directory " + dirName + " cannot be created. Possibly invalid directory name or inadequate authority.");
                    }
                } else {
                    System.out.println("Directory " + dirName + " already exists.");
                }
            }
        }
        catch (Exception e) {
            System.out.println("Failed to create " + dirName + ":");
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("MakeDirectory -- Demonstrates how to create a new directory.");
        System.out.println("Usage:");
        System.out.println("\tjava com.ibm.jzos.sample.nonvsam.directory.MakeDirectory directoryName");
        System.out.println("\tdirectoryName: The name of the directory to create");
        System.out.println("\t\tExample directoryName");
        System.out.println("\t\t\tHFS Directory: /tmp/USERID/hfsdir");
        System.out.println("\t\t\tPDS Directory: //PRIVATE.PDS or //'USERID.PRIVATE.PDS'");
        System.out.println();
        System.exit(0);
    }
}

