/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.nonvsam.directory;

import com.ibm.jzos.PdsDirectory;
import java.io.File;
import java.io.FileFilter;

public class ListDirectory {
    public static void main(String[] args) {
        if (args.length != 1) {
            ListDirectory.usage();
        }
        String dirName = args[0];
        ListDirectory.listAll(dirName);
        ListDirectory.listSubdirectories(dirName);
    }

    private static void listAll(String dirName) {
        try {
            if (dirName.startsWith("//")) {
                int length = 0;
                PdsDirectory dir = new PdsDirectory(dirName);
                System.out.println("Objects in the directory " + dirName + ": ");
                for (PdsDirectory.MemberInfo info : dir) {
                    System.out.println(info);
                    ++length;
                }
                System.out.println("Total number of objects in the directory " + dirName + ": " + length);
            } else {
                File dir = new File(dirName);
                String[] objects = dir.list();
                if (objects != null && objects.length > 0) {
                    System.out.println("Total number of objects in the directory " + dirName + ": " + objects.length);
                    System.out.println("Objects in the directory " + dirName + ": ");
                    for (int i = 0; i < objects.length; ++i) {
                        System.out.println(objects[i]);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Failed to list " + dirName + ". Exception caught: ");
            e.printStackTrace();
        }
    }

    public static void listSubdirectories(String dirName) {
        try {
            FileFilter fileFilter;
            File dir;
            File[] subdirectories;
            if (!dirName.startsWith("//") && (subdirectories = (dir = new File(dirName)).listFiles(fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            })) != null && subdirectories.length > 0) {
                System.out.println("Total number of subdirectories in the directory " + dirName + ": " + subdirectories.length);
                System.out.println("Subdirectories in the directory " + dirName + ": ");
                for (int i = 0; i < subdirectories.length; ++i) {
                    System.out.println(subdirectories[i]);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Failed to list " + dirName + ". Exception caught: ");
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("ListDirectory -- Demonstrates how to list the contents of a directory in two different ways.");
        System.out.println("Usage:");
        System.out.println("\tjava com.ibm.jzos.sample.nonvsam.directory.ListDirectory directoryName");
        System.out.println("\tdirectoryName: The name of the directory to list");
        System.out.println("\t\tExample directoryName");
        System.out.println("\t\t\tHFS Directory: /etc");
        System.out.println("\t\t\tPDS Directory: //PRIVATE.PDS or //'USERID.PRIVATE.PDS'");
        System.out.println();
        System.exit(0);
    }
}

