/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.dfsort;

import com.ibm.jzos.DfSort;
import com.ibm.jzos.RDWOutputRecordStream;
import com.ibm.jzos.RcException;
import com.ibm.jzos.sample.dfsort.DfSortArguments;
import com.ibm.jzos.sample.dfsort.DsInfo;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

public class DfSortVariableJavaToDataset {
    private static final String RECORD_DATA = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    public static void main(String[] args) throws Exception {
        DsInfo outDs;
        DfSortArguments dfsortArgs = new DfSortArguments(args);
        if (dfsortArgs.getSortoutDataset() == null || dfsortArgs.getNumrecs() < 0) {
            System.err.println("Usage: " + DfSortVariableJavaToDataset.class.getName() + " sortout=<dsn> numrecs=<nn> [shareas=<yes|NO>]");
            System.err.println("\tsortout is an existing RECFM=V DSN to hold DFSORT output");
            System.err.println("\tnumrecs is the number of records to generate");
            System.err.println("\tshareas = yes: DFSORT executes in the same address space as the JVM");
            System.exit(4);
        }
        if (!(outDs = dfsortArgs.getSortoutDataset()).isVariableRecfm()) {
            System.err.println("Dataset " + outDs.getFullyQualifiedDsn() + " is not RECFM=V");
            System.exit(8);
        }
        DfSortVariableJavaToDataset.doSort(dfsortArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSort(DfSortArguments dfsortArgs) throws Exception {
        DsInfo outDs = dfsortArgs.getSortoutDataset();
        DfSort dfSort = new DfSort();
        if (dfsortArgs.getLogLevel() != -1) {
            dfSort.setLoggingLevel(dfsortArgs.getLogLevel());
        }
        dfSort.setInputStreamHasRdws();
        dfSort.addAllocation("alloc fi(sortout) da(" + outDs.getFullyQualifiedDsn() + ") reuse shr msg(2)");
        dfSort.addControlStatement("OPTION VLSHRT");
        dfSort.addControlStatement("SORT FIELDS=(5,25,CH,A)");
        dfSort.addControlStatement("RECORD TYPE=V,LENGTH=(" + outDs.getLrecl() + ")");
        dfSort.setSameAddressSpace(dfsortArgs.isSameAddressSpace());
        long startTime = System.currentTimeMillis();
        dfSort.execute();
        RDWOutputRecordStream rdwos = new RDWOutputRecordStream((OutputStream)new BufferedOutputStream(dfSort.getChildStdinStream()));
        byte[] byte_data = RECORD_DATA.getBytes();
        byte[] record = new byte[outDs.getLrecl()];
        try {
            for (int i = 0; i < dfsortArgs.getNumrecs(); ++i) {
                int s = i % (byte_data.length - 1);
                int j = 0;
                while (j < record.length) {
                    record[j] = byte_data[s % (byte_data.length - 1)];
                    ++j;
                    ++s;
                }
                int dataLen = Math.max(1, i % outDs.getLrecl() - 4);
                rdwos.write(record, 0, dataLen);
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        finally {
            rdwos.close();
        }
        int rc = 0;
        try {
            rc = dfSort.getReturnCode();
        }
        catch (RcException rce) {
            System.out.println("Caught RcException: " + rce.getMessage());
            rc = -1;
        }
        long runtime = System.currentTimeMillis() - startTime;
        if (rc != 0 || dfsortArgs.getLogLevel() >= 0) {
            List stderrLines = dfSort.getStderrLines();
            Iterator i = stderrLines.iterator();
            while (i.hasNext()) {
                System.err.println(i.next());
            }
        }
        System.out.println("RC=" + rc + " TIME=" + runtime + " RECORD COUNT=" + dfsortArgs.getNumrecs() + " " + DfSortVariableJavaToDataset.class.getName());
    }
}

