/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.dfsort;

import com.ibm.jzos.DfSort;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.sample.dfsort.DfSortArguments;
import com.ibm.jzos.sample.dfsort.DsInfo;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;

public class DfSortCopyFixedDatasetToJava {
    public static void main(String[] args) throws Exception {
        DsInfo inDs;
        DfSortArguments dfsortArgs = new DfSortArguments(args);
        if (dfsortArgs.getSortinDataset() == null) {
            System.err.println("Usage: " + DfSortCopyFixedDatasetToJava.class.getName() + " sortin=<dsn> [encoding=<codepage>] [shareas=<yes|NO>]");
            System.err.println("Where:");
            System.err.println("\tsortin is a RECFM=F dataset");
            System.err.println("\tencoding is the source character set.  If not supplied, raw bytes are processed.");
            System.err.println("\tshareas = yes: DFSORT executes in the same address space as the JVM");
            System.exit(4);
        }
        if (!(inDs = dfsortArgs.getSortinDataset()).isFixedRecfm()) {
            System.err.println("Dataset " + inDs.getFullyQualifiedDsn() + " is not RECFM=F");
            System.exit(8);
        }
        DfSortCopyFixedDatasetToJava.doSort(dfsortArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSort(DfSortArguments dfsortArgs) throws Exception {
        DsInfo inDs = dfsortArgs.getSortinDataset();
        DfSort dfSort = new DfSort();
        if (dfsortArgs.getLogLevel() != -1) {
            dfSort.setLoggingLevel(dfsortArgs.getLogLevel());
        }
        dfSort.addAllocation("alloc fi(sortin) da(" + inDs.getFullyQualifiedDsn() + ") reuse shr msg(2)");
        dfSort.setOutputStreamRecLen(inDs.getLrecl());
        dfSort.addControlStatement("SORT FIELDS=COPY");
        dfSort.setSameAddressSpace(dfsortArgs.isSameAddressSpace());
        long startTime = System.currentTimeMillis();
        dfSort.execute();
        BufferedInputStream bis = new BufferedInputStream(dfSort.getChildStdoutStream());
        byte[] bytes = new byte[inDs.getLrecl()];
        int recordCount = 0;
        while (DfSortCopyFixedDatasetToJava.readRecord(bis, bytes)) {
            if (dfsortArgs.getEncoding() != null) {
                String string = new String(bytes, dfsortArgs.getEncoding());
            }
            ++recordCount;
        }
        bis.close();
        int rc = 0;
        try {
            rc = dfSort.getReturnCode();
        }
        catch (RcException rce) {
            System.out.println("Caught RcException: " + rce.getMessage());
            rc = -1;
        }
        long dfsortRuntime = System.currentTimeMillis() - startTime;
        if (rc != 0 || dfsortArgs.getLogLevel() >= 0) {
            List stderrLines = dfSort.getStderrLines();
            Iterator i = stderrLines.iterator();
            while (i.hasNext()) {
                System.err.println(i.next());
            }
        }
        startTime = System.currentTimeMillis();
        recordCount = 0;
        try (ZFile zFileIn = new ZFile(inDs.getZFileDsn(), "rb,type=record,noseek");){
            int nRead;
            byte[] recBuf = new byte[zFileIn.getLrecl()];
            while ((nRead = zFileIn.read(recBuf)) >= 0) {
                ++recordCount;
            }
        }
        long zfileRuntime = System.currentTimeMillis() - startTime;
        System.out.println("RC=" + rc + " DFSORT TIME=" + dfsortRuntime + " ZFILE TIME=" + zfileRuntime + " RECORD COUNT=" + recordCount + " " + DfSortCopyFixedDatasetToJava.class.getName());
    }

    private static boolean readRecord(InputStream is, byte[] bytes) throws IOException {
        int offset = 0;
        int bytesToRead = bytes.length;
        int c = is.read();
        if (c == -1) {
            return false;
        }
        bytes[offset++] = (byte)c;
        --bytesToRead;
        while (bytesToRead > 0) {
            int bytesRead = is.read(bytes, offset, bytesToRead);
            if (bytesRead == -1) {
                throw new IOException("EOF encountered before all record bytes read");
            }
            bytesToRead -= bytesRead;
            offset += bytesRead;
        }
        return true;
    }
}

