/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.dfsort;

import com.ibm.jzos.ZFileException;
import com.ibm.jzos.sample.dfsort.DsInfo;
import java.util.StringTokenizer;

public class DfSortArguments {
    private DsInfo sortinDataset;
    private DsInfo sortoutDataset;
    private boolean sameAddressSpace = false;
    private int lrecl = -1;
    private int numrecs = -1;
    private String encoding;
    private int logLevel = -1;

    public DfSortArguments(String[] args) throws ZFileException {
        for (int i = 0; i < args.length; ++i) {
            StringTokenizer strtok = new StringTokenizer(args[i], "=");
            if (strtok.countTokens() != 2) {
                throw new IllegalArgumentException("Argument '" + args[i] + "' not in the form: name=value");
            }
            String name = strtok.nextToken();
            String value = strtok.nextToken();
            if ("sortin".equalsIgnoreCase(name)) {
                this.sortinDataset = new DsInfo(value);
                continue;
            }
            if ("sortout".equalsIgnoreCase(name)) {
                this.sortoutDataset = new DsInfo(value);
                continue;
            }
            if ("shareas".equalsIgnoreCase(name)) {
                this.sameAddressSpace = "yes".equalsIgnoreCase(value);
                continue;
            }
            if ("lrecl".equalsIgnoreCase(name)) {
                this.lrecl = Integer.parseInt(value);
                continue;
            }
            if ("numrecs".equalsIgnoreCase(name)) {
                this.numrecs = Integer.parseInt(value);
                continue;
            }
            if ("encoding".equalsIgnoreCase(name)) {
                this.encoding = value;
                continue;
            }
            if ("loglevel".equalsIgnoreCase(name)) {
                this.logLevel = Integer.parseInt(value);
                continue;
            }
            throw new IllegalArgumentException("Argument '" + name + "' not recognized.");
        }
    }

    public DsInfo getSortinDataset() {
        return this.sortinDataset;
    }

    public DsInfo getSortoutDataset() {
        return this.sortoutDataset;
    }

    public boolean isSameAddressSpace() {
        return this.sameAddressSpace;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getLrecl() {
        return this.lrecl;
    }

    public int getNumrecs() {
        return this.numrecs;
    }

    public int getLogLevel() {
        return this.logLevel;
    }
}

