/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.compress;

import com.ibm.jzos.BufferCompressor;
import com.ibm.jzos.CompressionFactory;
import com.ibm.jzos.RecordReader;
import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;

public class ExpandRecords {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: com.ibm.jzos.sample.compress.ExpandRecords inDSN outDSN");
            System.err.println("   Note: System property com.ibm.jzos.compression.type may be used to configure compression type");
            System.exit(8);
        }
        String fnIn = ZFile.getSlashSlashQuotedDSN((String)args[0], (boolean)true);
        String fnOut = ZFile.getSlashSlashQuotedDSN((String)args[1], (boolean)true);
        RecordReader reader = null;
        RecordWriter writer = null;
        CompressionFactory factory = null;
        try {
            int nRead;
            reader = RecordReader.newReader((String)fnIn, (int)1);
            if (reader.getRecfm().startsWith("F")) {
                throw new IllegalStateException("Illegal input RECFM=" + reader.getRecfm());
            }
            writer = RecordWriter.newWriter((String)fnOut, (int)4);
            factory = CompressionFactory.getDefault();
            BufferCompressor comp = factory.getBufferCompressor();
            System.out.println("Using: " + String.valueOf(comp.getClass()));
            byte[] inBuf = new byte[reader.getLrecl()];
            byte[] outBuf = new byte[writer.getLrecl()];
            long nRecs = 0L;
            long nTotalRead = 0L;
            long nTotalWritten = 0L;
            long time = System.currentTimeMillis();
            while ((nRead = reader.read(inBuf)) >= 0) {
                int elen = comp.expandBuffer(outBuf, 0, inBuf, 0, nRead);
                if (elen < 0) {
                    throw new RuntimeException("Compressed buffer of length " + nRead + " would not fit into expanded buffer of length " + outBuf.length);
                }
                writer.write(outBuf, 0, elen);
                ++nRecs;
                nTotalRead += (long)nRead;
                nTotalWritten += (long)elen;
            }
            float secs = System.currentTimeMillis() - time;
            System.out.println("Expanded " + nRecs + " records; bytes read/written=" + nTotalRead + "/" + nTotalWritten + " in " + (secs /= 1000.0f) + " seconds");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable throwable) {}
            }
            if (factory != null) {
                factory.release();
            }
        }
    }
}

