/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.compress;

import com.ibm.jzos.BufferCompressor;
import com.ibm.jzos.CompressionFactory;
import com.ibm.jzos.RecordReader;
import com.ibm.jzos.RecordWriter;
import com.ibm.jzos.ZFile;

public class CompressRecords {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: com.ibm.jzos.test.CompressRecords inDSN outDSN");
            System.err.println("   Note: System property com.ibm.jzos.compression.type may be used to configure compression type");
            System.exit(8);
        }
        String fnIn = ZFile.getSlashSlashQuotedDSN((String)args[0], (boolean)true);
        String fnOut = ZFile.getSlashSlashQuotedDSN((String)args[1], (boolean)true);
        RecordReader reader = null;
        RecordWriter writer = null;
        CompressionFactory factory = null;
        try {
            int nRead;
            reader = RecordReader.newReader((String)fnIn, (int)1);
            writer = RecordWriter.newWriter((String)fnOut, (int)4);
            if (writer.getRecfm().startsWith("F")) {
                throw new IllegalStateException("Illegal output dataset RECFM=" + writer.getRecfm());
            }
            byte[] inBuf = new byte[reader.getLrecl()];
            byte[] outBuf = new byte[writer.getLrecl()];
            long nRecs = 0L;
            long nTotalRead = 0L;
            long nTotalWritten = 0L;
            factory = CompressionFactory.getDefault();
            BufferCompressor comp = factory.getBufferCompressor();
            System.out.println("Using: " + String.valueOf(comp.getClass()));
            long time = System.currentTimeMillis();
            while ((nRead = reader.read(inBuf)) >= 0) {
                int clen = comp.compressBuffer(outBuf, 0, inBuf, 0, nRead);
                if (clen <= 0) {
                    throw new RuntimeException("Compressed buffer of length " + nRead + " would not fit in output buffer with length " + outBuf.length);
                }
                writer.write(outBuf, 0, clen);
                ++nRecs;
                nTotalRead += (long)nRead;
                nTotalWritten += (long)clen;
            }
            float secs = System.currentTimeMillis() - time;
            System.out.println("Compressed " + nRecs + " records; bytes read/written=" + nTotalRead + "/" + nTotalWritten + " in " + (secs /= 1000.0f) + " seconds");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable throwable) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable throwable) {}
            }
            if (factory != null) {
                factory.release();
            }
        }
    }
}

