/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample.compress;

import com.ibm.jzos.CompressionFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class CompressFile {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: com.ibm.jzos.sample.compress.CompressFile infile outfile");
            System.err.println("   Note: System property com.ibm.jzos.compression.type may be used to configure compression type");
            System.exit(8);
        }
        String fnIn = args[0];
        String fnOut = args[1];
        FileInputStream input = null;
        OutputStream output = null;
        CompressionFactory factory = null;
        try {
            int nRead;
            factory = CompressionFactory.getDefault();
            input = new FileInputStream(fnIn);
            output = factory.getCompressingOutputStream((OutputStream)new FileOutputStream(fnOut));
            System.out.println("Using: " + String.valueOf(output.getClass()));
            byte[] buf = new byte[16384];
            long time = System.currentTimeMillis();
            long totalSourceBytes = 0L;
            while ((nRead = ((InputStream)input).read(buf)) >= 0) {
                totalSourceBytes += (long)nRead;
                output.write(buf, 0, nRead);
            }
            ((InputStream)input).close();
            output.close();
            float secs = System.currentTimeMillis() - time;
            System.out.println("Compressed " + totalSourceBytes + "->" + new File(fnOut).length() + " bytes in " + (secs /= 1000.0f) + " seconds");
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (Throwable throwable) {}
            }
            if (factory != null) {
                factory.release();
            }
        }
    }
}

