/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample;

import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZFileException;
import java.util.Arrays;

public class ZFileKSDS {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String filename = "//DD:KSDS";
        String options = "ab+,type=record";
        int lrecl = 80;
        int keyLen = 8;
        try (ZFile zfile = new ZFile(filename, options);){
            byte[] rec_1 = ZFileKSDS.padToLength("AAAAAAAARecord 1", lrecl).getBytes("IBM-1047");
            byte[] rec_2 = ZFileKSDS.padToLength("BBBBBBBBRecord 2", lrecl).getBytes("IBM-1047");
            byte[] rec_3 = ZFileKSDS.padToLength("CCCCCCCCRecord 3", lrecl).getBytes("IBM-1047");
            byte[] recBuf = new byte[lrecl];
            zfile.write(rec_1);
            zfile.write(rec_2, 0, rec_2.length);
            zfile.write(rec_3);
            ZFileKSDS.check("Found first record", zfile.locate(rec_1, 0, keyLen, 3));
            int nRead = zfile.read(recBuf);
            ZFileKSDS.check("read len", lrecl == nRead);
            ZFileKSDS.check("rec_1 contents", Arrays.equals(rec_1, recBuf));
            byte[] rec_1U = ZFileKSDS.padToLength("AAAAAAAARecord 1 updated", lrecl).getBytes("IBM-1047");
            int nUpdated = zfile.update(rec_1U);
            ZFileKSDS.check("update len", lrecl == nUpdated);
            ZFileKSDS.check("Locate rec_1", zfile.locate(rec_1, 0, keyLen, 3));
            nRead = zfile.read(recBuf);
            ZFileKSDS.check("read len", lrecl == nRead);
            ZFileKSDS.check("rec_1U contents", Arrays.equals(rec_1U, recBuf));
            byte[] keybuf = new byte[keyLen];
            System.arraycopy(rec_2, 0, keybuf, 0, keyLen);
            ZFileKSDS.check("Locate rec_2", zfile.locate(keybuf, 3));
            nRead = zfile.read(recBuf);
            ZFileKSDS.check("read len", lrecl == nRead);
            ZFileKSDS.check("rec_2 contents", Arrays.equals(rec_2, recBuf));
            byte[] rec_2U = ZFileKSDS.padToLength("BBBBBBBBRecord 2 updated", lrecl).getBytes("IBM-1047");
            nUpdated = zfile.update(rec_2U, 0, rec_2U.length);
            ZFileKSDS.check("update len", lrecl == nUpdated);
            ZFileKSDS.check("Locate rec_2", zfile.locate(rec_2, 0, keyLen, 3));
            nRead = zfile.read(recBuf);
            ZFileKSDS.check("read len", lrecl == nRead);
            ZFileKSDS.check("rec_2U contents", Arrays.equals(rec_2U, recBuf));
            ZFileKSDS.check("Locate rec_1", zfile.locate(rec_1, 0, keyLen, 3));
            nRead = zfile.read(recBuf);
            zfile.delrec();
            ZFileKSDS.check("Locate rec_2", zfile.locate(rec_2, 0, keyLen, 3));
            nRead = zfile.read(recBuf);
            zfile.delrec();
            ZFileKSDS.check("Locate rec_3", zfile.locate(rec_3, 0, keyLen, 3));
            nRead = zfile.read(recBuf);
            zfile.delrec();
            try {
                zfile.delrec();
                ZFileKSDS.check("Expected exception from delrec()", false);
            }
            catch (ZFileException zfe) {
                System.out.println("Expected exception: " + String.valueOf((Object)zfe));
                ZFileKSDS.check("zfe.getErrno = " + zfe.getErrno(), 76 == zfe.getErrno());
            }
            ZFileKSDS.check("Locate rec_2 after deleting", !zfile.locate(rec_2, 0, keyLen, 3));
        }
    }

    static String padToLength(String s, int len) {
        StringBuffer sb = new StringBuffer(len);
        sb.append(s);
        for (int i = s.length(); i < len; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    static void check(String msg, boolean value) {
        if (!value) {
            throw new RuntimeException(msg);
        }
    }
}

