/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample;

import com.ibm.jzos.FileFactory;
import com.ibm.jzos.MvsJobSubmitter;
import com.ibm.jzos.sample.MvsJob;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class MvsSubmitJob {
    public static final long ONE_SECOND = 1000L;
    public static final long TWO_SECONDS = 2000L;
    public static final long ONE_MINUTE = 60000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            throw new IllegalArgumentException("Missing main argument: filename");
        }
        String jobname = null;
        MvsJobSubmitter jobSubmitter = new MvsJobSubmitter();
        try (BufferedReader rdr = FileFactory.newBufferedReader((String)args[0]);){
            String line;
            while ((line = rdr.readLine()) != null) {
                StringTokenizer tok;
                String jobToken;
                if (jobname == null && (jobToken = (tok = new StringTokenizer(line)).nextToken()).startsWith("//")) {
                    jobname = jobToken.substring(2);
                }
                jobSubmitter.write(line);
            }
        }
        jobSubmitter.close();
        boolean completed = false;
        long begin = System.currentTimeMillis();
        MvsJob job = new MvsJob(jobname, jobSubmitter.getJobid());
        do {
            String status = job.getStatus();
            System.out.println(String.valueOf(job) + " " + status);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean bl = completed = !status.startsWith("WAITING") && !status.startsWith("EXECUTING");
        } while (!completed && System.currentTimeMillis() - begin < 60000L);
    }
}

