/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample;

import com.ibm.jzos.Exec;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZUtil;
import com.ibm.jzos.sample.MvsJob;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.StringTokenizer;

public class MvsJobOutput {
    public static final String JOB_STATUS_CMD = "jobStatus";
    public static final String JOB_OUTPUT_CMD = "jobOutput";

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            throw new IllegalArgumentException("Missing arguments: jobname jobid");
        }
        MvsJob mvsJob = new MvsJob(args[0], args[1]);
        System.out.println("JOB " + String.valueOf(mvsJob) + " " + MvsJobOutput.getStatus(mvsJob));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(System.out));
        MvsJobOutput.writeJobOutput(mvsJob, writer);
        writer.close();
    }

    public static String getStatus(MvsJob job) throws IOException {
        Exec exec = new Exec(MvsJobOutput.getStatusCommand(job), MvsJobOutput.getEnvironment());
        exec.run();
        String line = exec.readLine();
        if (line == null) {
            throw new IOException("No output from jobStatus child process");
        }
        BufferedWriter wdr = exec.getStdinWriter();
        wdr.close();
        while (exec.readLine() != null) {
        }
        int rc = exec.getReturnCode();
        if (rc != 0) {
            throw new RcException("REXX 'jobStatus' process failed: " + line, rc);
        }
        StringTokenizer tok = new StringTokenizer(line);
        if (tok.countTokens() < 3) {
            throw new IOException("Invalid output from jobStatus child process: " + line);
        }
        String next = tok.nextToken();
        if (next.startsWith("IKJ")) {
            next = tok.nextToken();
        }
        if (!next.equalsIgnoreCase("JOB")) {
            throw new IOException("Invalid output from jobStatus child process: " + line);
        }
        tok.nextToken();
        Object answer = "";
        while (tok.hasMoreTokens()) {
            answer = (String)answer + tok.nextToken();
            if (!tok.hasMoreTokens()) continue;
            answer = (String)answer + " ";
        }
        return answer;
    }

    protected static String getStatusCommand(MvsJob job) {
        Object cmdPath = System.getProperty("jzos.script.path", "");
        if (((String)cmdPath).length() > 0 && !((String)cmdPath).endsWith("/")) {
            cmdPath = (String)cmdPath + "/";
        }
        cmdPath = (String)cmdPath + "jobStatus " + job.getJobname() + " ";
        if (job.getJobid() != null) {
            cmdPath = (String)cmdPath + job.getJobid();
        }
        return cmdPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJobOutput(MvsJob mvsJob, Writer writer) throws IOException {
        Exec exec = new Exec(MvsJobOutput.getJobOutputCommand(mvsJob), MvsJobOutput.getEnvironment());
        exec.run();
        try {
            String line;
            while ((line = exec.readLine()) != null) {
                writer.write(line);
                writer.write(10);
            }
            writer.flush();
        }
        finally {
            int rc = exec.getReturnCode();
            if (rc != 0) {
                throw new RcException("REXX 'jobOutput' process failed", rc);
            }
        }
    }

    protected static String getJobOutputCommand(MvsJob mvsJob) {
        Object cmdPath = System.getProperty("jzos.script.path", "");
        if (((String)cmdPath).length() > 0 && !((String)cmdPath).endsWith("/")) {
            cmdPath = (String)cmdPath + "/";
        }
        return (String)cmdPath + "jobOutput " + mvsJob.getJobname() + " " + mvsJob.getJobid();
    }

    protected static String[] getEnvironment() {
        Properties p = ZUtil.getEnvironment();
        p.put("_BPX_SHAREAS", "YES");
        p.put("_BPX_SPAWN_SCRIPT", "YES");
        String[] environ = new String[p.size()];
        int i = 0;
        for (String string : p.keySet()) {
            environ[i++] = string + "=" + p.getProperty(string);
        }
        return environ;
    }
}

