/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample;

import com.ibm.jzos.CatalogSearch;
import com.ibm.jzos.CatalogSearchField;
import com.ibm.jzos.Format1DSCB;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import java.io.PrintWriter;

public class GetRecfmForDataset {
    private static int INVALID_FILTER_KEY = 122;
    private static int CATALOG_ERROR = 100;
    private static String recfmOut;

    public static void main(String[] args) throws Exception {
        PrintWriter writer = new PrintWriter(System.out);
        if (args.length < 1) {
            writer.println("USAGE: GetRecfmForDataset <filter_key> [entry_types]");
            writer.flush();
            System.exit(1);
        }
        String filterKey = args[0].toUpperCase();
        writer.println("Performing Catalog Search with filter key: " + filterKey);
        CatalogSearch catSearch = new CatalogSearch(filterKey, 64000);
        if (args.length == 2) {
            catSearch.setEntryTypes(args[1]);
        }
        int datasetCount = 0;
        try {
            catSearch.addFieldName("ENTNAME");
            catSearch.addFieldName("VOLSER");
            catSearch.search();
            while (catSearch.hasNext()) {
                CatalogSearch.Entry entry = catSearch.next();
                if (!entry.isDatasetEntry()) continue;
                ++datasetCount;
                CatalogSearchField field = entry.getField("ENTNAME");
                String dsn = field.getFString().trim();
                String qdsn = "'" + dsn + "'";
                field = entry.getField("VOLSER");
                String volser = field.getFString().trim();
                if (volser == null || volser.length() == 0) {
                    writer.println(qdsn + " has no VOLSER");
                    continue;
                }
                String resolvedName = volser;
                if (volser.indexOf(38) != -1) {
                    try {
                        resolvedName = ZUtil.substituteSystemSymbols((String)volser, (boolean)true);
                    }
                    catch (RcException rce) {
                        writer.println("Could not resolve symbolic VOLSER '" + volser + "'.  Skipping...");
                        continue;
                    }
                    writer.println("...Resolved '" + volser + "' as '" + resolvedName);
                }
                try {
                    Format1DSCB dscb = ZFile.obtainDSN((String)qdsn, (String)resolvedName);
                    int recfm = dscb.getDS1RECFM();
                    int length = recfm & 0xC0;
                    int bt = recfm & 0x30;
                    if (length == 192) {
                        if (bt == 16) {
                            recfmOut = "UB";
                            continue;
                        }
                        if (bt == 32) {
                            recfmOut = "UT";
                            continue;
                        }
                        recfmOut = "U";
                        continue;
                    }
                    if (length == 128) {
                        if (bt == 16) {
                            recfmOut = "FB";
                            continue;
                        }
                        if (bt == 32) {
                            recfmOut = "FT";
                            continue;
                        }
                        recfmOut = "F";
                        continue;
                    }
                    if (length != 64) continue;
                    if (bt == 16) {
                        recfmOut = "VB";
                        continue;
                    }
                    if (bt == 32) {
                        recfmOut = "VT";
                        continue;
                    }
                    recfmOut = "V";
                }
                catch (RcException rce) {
                    String reason = "";
                    if (rce.getRc() == 4) {
                        reason = " Volume not mounted";
                    } else if (rce.getRc() == 8) {
                        reason = " Volume does not contain a format 1 DSCB for dataset";
                    }
                    writer.println(qdsn + " on " + resolvedName + reason);
                }
            }
        }
        catch (RcException rce) {
            if (rce.getRc() == 4 && catSearch.getRc() == INVALID_FILTER_KEY) {
                writer.println("Invalid filter key provided: " + filterKey);
                writer.flush();
            }
            if (rce.getRc() == 4 && catSearch.getRc() == CATALOG_ERROR) {
                while (catSearch.hasNext()) {
                    CatalogSearch.Entry entry = catSearch.next();
                    if (!entry.hasError()) continue;
                    writer.println("Entry Exception: ENTRY_RC=" + entry.getRc() + ", ENTRY_Reason=" + entry.getReason());
                    writer.flush();
                }
            }
            throw rce;
        }
        writer.println(datasetCount + " datasets matched filter key " + filterKey + ".");
        writer.println("\n" + filterKey + " RECFM = " + recfmOut + "\n");
        writer.flush();
    }

    private static String toString(int value, int radix, int padToMin) {
        String base = Integer.toString(value, radix);
        int padLen = padToMin - base.length();
        if (padLen > 0) {
            return "00000000000000000000000000000000".substring(0, padLen) + base;
        }
        return base;
    }
}

