/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.sample;

import com.ibm.jzos.Enqueue;
import com.ibm.jzos.RcException;
import com.ibm.jzos.ZFile;
import com.ibm.jzos.ZUtil;
import java.io.IOException;
import java.util.Date;

public class EnqUpdatePdsMember {
    private String ddname;
    private boolean allocated;
    private String pdsName;
    private String memberName;
    private Enqueue enqMember;
    private Enqueue enqDSN;

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: fully.qualfied.pds.name  membername");
            System.exit(8);
        }
        EnqUpdatePdsMember instance = new EnqUpdatePdsMember(args[0], args[1]);
        instance.update();
    }

    public EnqUpdatePdsMember(String pdsName, String memberName) {
        this.pdsName = ZFile.getFullyQualifiedDSN((String)pdsName, (boolean)true);
        this.memberName = memberName.toUpperCase();
    }

    public synchronized boolean update() throws IOException {
        try {
            this.doAllocate();
            if (!this.doEnqMember()) {
                boolean bl = false;
                return bl;
            }
            this.doEnqDSN();
            this.doUpdateMember();
            boolean bl = true;
            return bl;
        }
        finally {
            this.doReleaseEnqDSN();
            this.doReleaseEnqMem();
            this.doUnallocate();
        }
    }

    private void doAllocate() {
        this.ddname = ZFile.allocDummyDDName();
        ZFile.bpxwdyn((String)("alloc fi(" + this.ddname + ") da(" + this.pdsName + ") reuse shr msg(wtp)"));
        this.allocated = true;
        System.out.println("Allocated " + this.pdsName + " to DD:" + this.ddname + " DISP=SHR");
    }

    private boolean doEnqMember() {
        block5: {
            StringBuffer rnameMem = new StringBuffer();
            rnameMem.append(this.pdsName);
            while (rnameMem.length() < 44) {
                rnameMem.append(' ');
            }
            rnameMem.append(this.memberName);
            while (rnameMem.length() < 52) {
                rnameMem.append(' ');
            }
            this.enqMember = new Enqueue("SPFEDIT", rnameMem.toString());
            this.enqMember.setScope(3);
            this.enqMember.setControl(2);
            this.enqMember.setContentionActFail();
            try {
                this.enqMember.obtain();
                System.out.println("Obtained ENQ on SPFEDIT/\"" + String.valueOf(rnameMem) + "\"");
            }
            catch (RcException rce) {
                if (rce.getRc() == 263172) {
                    System.out.println(this.pdsName + "(" + this.memberName + ") is being used by someone else");
                    return false;
                }
                if (rce.getRc() == 263181) break block5;
                throw rce;
            }
        }
        return true;
    }

    private void doEnqDSN() {
        block3: {
            StringBuffer rnameDSN = new StringBuffer();
            rnameDSN.append(this.pdsName);
            while (rnameDSN.length() < 44) {
                rnameDSN.append(' ');
            }
            this.enqDSN = new Enqueue("SPFEDIT", rnameDSN.toString());
            this.enqDSN.setScope(3);
            this.enqDSN.setControl(2);
            this.enqDSN.setContentionActWait();
            try {
                this.enqDSN.obtain();
                System.out.println("Obtained ENQ on SPFEDIT/\"" + String.valueOf(rnameDSN) + "\"");
            }
            catch (RcException rce) {
                if (rce.getRc() == 263181) break block3;
                throw rce;
            }
        }
    }

    private void doUpdateMember() throws IOException {
        try (ZFile zFile = null;){
            zFile = new ZFile("//DD:" + this.ddname + "(" + this.memberName + ")", "wt");
            String line = "updated by EnqUpdatePdsMember at " + String.valueOf(new Date());
            zFile.write(line.getBytes(ZUtil.getDefaultPlatformEncoding()));
            System.out.println("Updated " + this.pdsName + "(" + this.memberName + ")");
        }
    }

    private void doUnallocate() {
        if (this.allocated) {
            try {
                ZFile.bpxwdyn((String)("free fi(" + this.ddname + ") msg(wtp)"));
                System.out.println("Freed DD:" + this.ddname);
            }
            catch (RcException rce) {
                rce.printStackTrace();
            }
        }
    }

    private void doReleaseEnqMem() {
        if (this.enqMember != null && this.enqMember.getEnqToken() != null) {
            try {
                this.enqMember.release();
                System.out.println("Released ENQ on \"" + this.enqMember.getRName() + "\"");
            }
            catch (RcException rce) {
                rce.printStackTrace();
            }
        }
    }

    private void doReleaseEnqDSN() {
        if (this.enqDSN != null && this.enqDSN.getEnqToken() != null) {
            try {
                this.enqDSN.release();
                System.out.println("Released ENQ on \"" + this.enqDSN.getRName() + "\"");
            }
            catch (RcException rce) {
                rce.printStackTrace();
            }
        }
    }
}

