/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.internal.cdi.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPluginResourceHandler;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CDIUIExtPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.etools.javaee.cdi.ext.ui";
    private static CDIUIExtPlugin plugin;
    private static boolean traceModeOn;
    public static final String[] ICON_DIRS;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        traceModeOn = "true".equals(Platform.getDebugOption((String)"com.ibm.etools.javaee.cdi.ext.ui/debug"));
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static void traceInfo(String msg) {
        if (traceModeOn) {
            ILog log = plugin.getLog();
            Status s = new Status(1, PLUGIN_ID, 0, msg, null);
            log.log((IStatus)s);
        }
    }

    public static boolean isTraceModeOn() {
        return traceModeOn;
    }

    public static CDIUIExtPlugin getDefault() {
        return plugin;
    }

    public static void logError(String message) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(CDIUIExtPlugin.createStatus(4, message));
    }

    public static void logError(String message, Throwable exception) {
        IStatus status = CDIUIExtPlugin.createStatus(4, message, exception);
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(status);
    }

    public static void logWarning(String message) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(CDIUIExtPlugin.createStatus(2, message));
    }

    public static void logWarning(String message, Throwable exception) {
        IStatus status = CDIUIExtPlugin.createStatus(2, message, exception);
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(status);
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, PLUGIN_ID, message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return CDIUIExtPlugin.createStatus(severity, message, null);
    }

    public Object getImage(String key) {
        return CDIUIExtPlugin.getImageURL(key, this.getBundle());
    }

    public static URL getImageURL(String key, Bundle bundle) {
        String gif = "/" + key + ".gif";
        String png = "/" + key + ".png";
        IPath pngPath = null;
        for (int i = 0; i < ICON_DIRS.length; ++i) {
            IPath gifPath = new Path(ICON_DIRS[i]).append(gif);
            pngPath = new Path(ICON_DIRS[i]).append(png);
            if (Platform.find((Bundle)bundle, (IPath)pngPath) != null) {
                try {
                    return new URL(bundle.getEntry("/"), pngPath.toString());
                }
                catch (MalformedURLException exception) {
                    CDIUIExtPlugin.logError(exception.toString());
                    continue;
                }
            }
            if (Platform.find((Bundle)bundle, (IPath)gifPath) == null) continue;
            try {
                return new URL(bundle.getEntry("/"), gifPath.toString());
            }
            catch (MalformedURLException exception) {
                Logger.getLogger().logWarning(J2EEPluginResourceHandler.getString((String)"Load_Image_Error_", (Object[])new Object[]{key}));
            }
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    static {
        ICON_DIRS = new String[]{"icons/obj16"};
    }
}

