/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.internal.cdi.annotations.processor.utils;

import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.AnnotationElements;
import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeElementDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.util.SourcePosition;
import java.util.Map;
import java.util.Set;

public class AnnotationCache {
    protected Declaration declaration;
    protected AnnotationMirror mirror;
    protected AnnotationElements elements;

    public AnnotationCache(Declaration declaration, AnnotationMirror mirror) {
        this.mirror = mirror;
        this.declaration = declaration;
        this.extractElements();
        CDIUIExtPlugin.traceInfo(this.toString());
    }

    public String toString() {
        return "[" + String.valueOf(this.declaration) + ", " + String.valueOf(this.mirror) + "@" + String.valueOf(this.mirror.getPosition()) + "]";
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public void setMirror(AnnotationMirror mirror) {
        this.mirror = mirror;
    }

    public AnnotationValue getElementAnnotationValue(String simpleName) {
        return this.elements.getElementAnnotationValue(simpleName);
    }

    public Object getElementValue(String simpleName) {
        return this.elements.getElementValue(simpleName);
    }

    public boolean isElementSpecified(String simpleName) {
        return this.elements.isElementSpecified(simpleName);
    }

    protected void extractElements() {
        this.elements = new AnnotationElements();
        Map valueMap = this.mirror.getElementValues();
        Set valueSet = valueMap.entrySet();
        for (Map.Entry annoKeyValue : valueSet) {
            String simpleName = ((AnnotationTypeElementDeclaration)annoKeyValue.getKey()).getSimpleName();
            AnnotationValue annoValue = (AnnotationValue)annoKeyValue.getValue();
            this.elements.put(simpleName, annoValue);
        }
    }

    public SourcePosition getSourcePosition(String elementName) {
        AnnotationValue elementValue = this.getElementAnnotationValue(elementName);
        if (elementValue != null) {
            return elementValue.getPosition();
        }
        return this.getSourcePosition();
    }

    public SourcePosition getSourcePosition() {
        if (this.mirror != null) {
            return this.mirror.getPosition();
        }
        return this.getDeclaration().getPosition();
    }

    public int getElementCount() {
        return this.elements.size();
    }
}

