/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.internal.cdi.annotations.processor.jcdi;

import com.ibm.etools.javaee.annotations.jcdi.utils.JCDIUtils;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.jcdi.AbstractAP;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.AnnotationCache;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.JcdiAPUtils;
import com.ibm.etools.javaee.internal.cdi.ui.CDIUIExtPlugin;
import com.ibm.etools.javaee.internal.cdi.ui.Messages;
import com.ibm.ws.ast.facets.core.FacetUtilities;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.AnnotationValue;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class TypedAP
extends AbstractAP {
    public static final String annotationName = "javax.enterprise.inject.Typed";

    public TypedAP(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        super(atds, env);
    }

    @Override
    public void process() {
        TypeDeclaration domType = (TypeDeclaration)this._env.getAST().types().get(0);
        ITypeBinding binding = domType.resolveBinding();
        IAnnotationBinding[] annos = binding.getAnnotations();
        boolean hasTypeBinding = false;
        for (int i = 0; i < annos.length; ++i) {
            if (!annos[i].getName().equals("Typed")) continue;
            IMemberValuePairBinding[] mvp = annos[i].getAllMemberValuePairs();
            for (int k = 0; k < mvp.length; ++k) {
                Object value = mvp[k].getValue();
                if (value instanceof Object[]) {
                    Object[] objs = (Object[])mvp[k].getValue();
                    for (int j = 0; j < objs.length; ++j) {
                        hasTypeBinding = objs[j] instanceof ITypeBinding;
                    }
                } else if (value instanceof ITypeBinding) {
                    hasTypeBinding = true;
                }
                if (!hasTypeBinding) continue;
                super.process();
            }
        }
    }

    @Override
    protected void processAnnotation(AnnotationCache annotation) {
        Declaration decl = annotation.getDeclaration();
        AnnotationValue aVal = annotation.getElementAnnotationValue("value");
        if (aVal != null) {
            List values = (List)aVal.getValue();
            if (decl instanceof ClassDeclaration) {
                IProject proj = this._env.getJavaProject().getProject();
                try {
                    if (FacetUtilities.hasFacet((IProject)proj, (String)"com.ibm.etools.javaee.cdi")) {
                        List managedBeans = JCDIUtils.getManagedBeans((ASTNode)this._env.getAST());
                        boolean isManagedBean = false;
                        String qName = ((ClassDeclaration)decl).getQualifiedName();
                        for (int i = 0; i < managedBeans.size(); ++i) {
                            if (!qName.equals(((TypeDeclaration)managedBeans.get(i)).resolveBinding().getQualifiedName())) continue;
                            isManagedBean = true;
                            break;
                        }
                        if (isManagedBean) {
                            TypeDeclaration domType = (TypeDeclaration)this._env.getAST().types().get(0);
                            if (values.size() > 0) {
                                List<String> unrestrictedTypes = JcdiAPUtils.getValidUnRestrictedTypes(domType.resolveBinding());
                                for (int i = 0; i < values.size(); ++i) {
                                    AnnotationValue val = (AnnotationValue)values.get(i);
                                    String restrictedQName = ((com.sun.mirror.declaration.TypeDeclaration)val.getValue()).getQualifiedName();
                                    if (unrestrictedTypes.contains(restrictedQName)) continue;
                                    this.getMessager().printError(val.getPosition(), Messages.bind((String)Messages.INVALID_RESTRICTED_TYPE, (Object[])new Object[]{val.getValue(), unrestrictedTypes}));
                                }
                            }
                        }
                    }
                }
                catch (CoreException e) {
                    CDIUIExtPlugin.logError(e.getMessage());
                }
            }
        }
    }

    @Override
    protected boolean isValidTarget(Declaration declaration) {
        return declaration instanceof ClassDeclaration;
    }

    @Override
    protected String getAnnotationName() {
        return annotationName;
    }
}

