/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.internal.cdi.annotations.processor.jcdi;

import com.ibm.etools.javaee.internal.cdi.annotations.processor.jcdi.AbstractAP;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.AnnotationCache;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.JcdiAPUtils;
import com.ibm.etools.javaee.internal.cdi.ui.Messages;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.ConstructorDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.ExecutableDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jst.javaee.ejb.InterceptorType;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.osgi.util.NLS;

public class ObservesAP
extends AbstractAP {
    public static final String annotationName = "javax.enterprise.event.Observes";
    private final String interfaceExtensionID = "javax.enterprise.inject.spi.Extension";
    private final String annotationDisposesID = "javax.enterprise.inject.Disposes";
    private final String annotationInterceptorID = "javax.interceptor.Interceptor";
    private final String invalidPrefix = "ejb";

    public ObservesAP(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        super(atds, env);
    }

    @Override
    protected void processAnnotation(AnnotationCache annotation) {
        TypeDeclaration typeDecl;
        ParameterDeclaration parameterDecl = (ParameterDeclaration)annotation.getDeclaration();
        Collection typeDecls = this._env.getTypeDeclarations();
        ExecutableDeclaration executableDecl = null;
        Iterator iterator = typeDecls.iterator();
        while (iterator.hasNext() && (executableDecl = JcdiAPUtils.getContainingExecutable(typeDecl = (TypeDeclaration)iterator.next(), parameterDecl)) == null) {
        }
        if (executableDecl == null) {
            return;
        }
        if (executableDecl instanceof ConstructorDeclaration) {
            this.getMessager().printError(parameterDecl.getPosition(), NLS.bind((String)Messages.OBSERVES_INVALID_CONSTRUCTOR, (Object)executableDecl.getSimpleName()));
            return;
        }
        if (JcdiAPUtils.isAbstract(executableDecl)) {
            this.getMessager().printError(parameterDecl.getPosition(), NLS.bind((String)Messages.OBSERVES_ABSTRACT_METHOD, (Object[])new String[]{parameterDecl.getSimpleName(), executableDecl.getSimpleName()}));
            return;
        }
        TypeDeclaration typeDecl2 = executableDecl.getDeclaringType();
        if (!(typeDecl2 instanceof ClassDeclaration)) {
            this.getMessager().printError(parameterDecl.getPosition(), NLS.bind((String)Messages.OBSERVES_INVALID_OBJECT, (Object)executableDecl.getSimpleName()));
            return;
        }
        ClassDeclaration classDecl = (ClassDeclaration)typeDecl2;
        SessionBean sessionBean = JcdiAPUtils.getSessionBean(classDecl, this._env.getJavaProject().getProject());
        if (sessionBean == null && !JcdiAPUtils.implementsOrExtends(typeDecl2, "javax.enterprise.inject.spi.Extension") && !JcdiAPUtils.isManagedBean((Declaration)typeDecl2, this._env.getJavaProject())) {
            this.getMessager().printError(parameterDecl.getPosition(), NLS.bind((String)Messages.OBSERVES_INVALID_OBJECT, (Object)executableDecl.getSimpleName()));
            return;
        }
        if (JcdiAPUtils.isAnnotatedWith((Declaration)typeDecl2, "javax.decorator.Decorator") || this.isInterceptor(typeDecl2)) {
            this.getMessager().printError(executableDecl.getPosition(), NLS.bind((String)Messages.OBSERVES_INTERCEPTOR_DECORATOR, (Object)executableDecl.getSimpleName()));
            return;
        }
        if (JcdiAPUtils.isAnnotatedWith((Declaration)executableDecl, "javax.inject.Inject") || JcdiAPUtils.isAnnotatedWith((Declaration)executableDecl, "javax.enterprise.inject.Produces")) {
            this.getMessager().printError(executableDecl.getPosition(), NLS.bind((String)Messages.OBSERVES_INVALID_METHOD_INJECT_PRODUCE, (Object)executableDecl.getSimpleName()));
            return;
        }
        if (sessionBean != null && !this.isValidBeanMethod(executableDecl)) {
            return;
        }
        if (!this.isMethodParamtersValid(executableDecl, parameterDecl)) {
            return;
        }
    }

    private boolean isValidBeanMethod(ExecutableDeclaration executableDecl) {
        if (JcdiAPUtils.isStatic((Declaration)executableDecl)) {
            return true;
        }
        if (executableDecl.getSimpleName().startsWith("ejb")) {
            this.getMessager().printError(executableDecl.getPosition(), NLS.bind((String)Messages.OBSERVES_INVALID_METHOD_NAME_EJB, (Object)executableDecl.getSimpleName()));
            return false;
        }
        if (!JcdiAPUtils.isPublic((Declaration)executableDecl)) {
            this.getMessager().printError(executableDecl.getPosition(), NLS.bind((String)Messages.OBSERVES_INVALID_METHOD_MODIFIER_NOT_PUBLIC, (Object)executableDecl.getSimpleName()));
            return false;
        }
        if (JcdiAPUtils.isFinal((Declaration)executableDecl)) {
            this.getMessager().printError(executableDecl.getPosition(), NLS.bind((String)Messages.OBSERVES_INVALID_METHOD_MODIFIER_FINAL, (Object)executableDecl.getSimpleName()));
            return false;
        }
        return true;
    }

    private boolean isMethodParamtersValid(ExecutableDeclaration executableDecl, ParameterDeclaration parameterDecl) {
        Collection parameters = executableDecl.getParameters();
        for (ParameterDeclaration paraDecl : parameters) {
            if (JcdiAPUtils.isAnnotatedWith((Declaration)paraDecl, "javax.enterprise.inject.Disposes")) {
                this.getMessager().printError(paraDecl.getPosition(), NLS.bind((String)Messages.OBSERVES_INVALID_PARAMETER_DISPOSE, (Object)executableDecl.getSimpleName()));
                return false;
            }
            if (paraDecl.equals((Object)parameterDecl) || !JcdiAPUtils.isAnnotatedWith((Declaration)paraDecl, annotationName)) continue;
            this.getMessager().printError(parameterDecl.getPosition(), NLS.bind((String)Messages.OBSERVES_MULTIPLE_OBSERVES_PARAMETERS, (Object[])new String[]{parameterDecl.getSimpleName(), executableDecl.getSimpleName()}));
            return false;
        }
        return true;
    }

    private boolean isInterceptor(TypeDeclaration typeDecl) {
        if (JcdiAPUtils.isAnnotatedWith((Declaration)typeDecl, "javax.interceptor.Interceptor")) {
            return true;
        }
        String qName = typeDecl.getQualifiedName();
        List<InterceptorType> interceptors = JcdiAPUtils.getEJBInterceptors(this._env.getJavaProject().getProject());
        if (interceptors == null) {
            return false;
        }
        for (InterceptorType interceptor : interceptors) {
            if (!qName.equals(interceptor.getInterceptorClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isValidTarget(Declaration declaration) {
        return declaration instanceof ParameterDeclaration;
    }

    @Override
    protected String getAnnotationName() {
        return annotationName;
    }
}

