/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.internal.cdi.annotations.processor.jcdi;

import com.ibm.etools.javaee.internal.cdi.annotations.processor.jcdi.AbstractAP;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.AnnotationCache;
import com.ibm.etools.javaee.internal.cdi.annotations.processor.utils.JcdiAPUtils;
import com.ibm.etools.javaee.internal.cdi.ui.Messages;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class DelegateAP
extends AbstractAP {
    public static final String annotationName = "javax.decorator.Delegate";

    public DelegateAP(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        super(atds, env);
    }

    @Override
    protected String getAnnotationName() {
        return annotationName;
    }

    @Override
    protected void processAnnotation(AnnotationCache annotation) {
        Declaration decl = annotation.getDeclaration();
        if (decl instanceof FieldDeclaration) {
            TypeDeclaration declType = ((FieldDeclaration)decl).getDeclaringType();
            if (!JcdiAPUtils.isAnnotatedWith((Declaration)declType, "javax.decorator.Decorator")) {
                this.getMessager().printError(decl.getPosition(), NLS.bind((String)Messages.DECORATOR_DELEGATE_WITHOUT_DECORATOR, (Object)decl.getSimpleName()));
            }
        } else if (decl instanceof ParameterDeclaration) {
            Declaration declType;
            AnnotationTypeDeclaration annoDecl = (AnnotationTypeDeclaration)this._env.getTypeDeclaration("javax.decorator.Decorator");
            if (annoDecl == null) {
                return;
            }
            Collection annotatedDecls = this._env.getDeclarationsAnnotatedWith(annoDecl);
            if (annotatedDecls == null) {
                this.getMessager().printError(decl.getPosition(), NLS.bind((String)Messages.DECORATOR_DELEGATE_WITHOUT_DECORATOR, (Object)decl.getSimpleName()));
                return;
            }
            boolean isDecorator = false;
            Iterator iterator = annotatedDecls.iterator();
            while (!(!iterator.hasNext() || (declType = (Declaration)iterator.next()) instanceof TypeDeclaration && (isDecorator = JcdiAPUtils.getContainingExecutable((TypeDeclaration)declType, (ParameterDeclaration)decl) != null))) {
            }
            if (!isDecorator) {
                this.getMessager().printError(decl.getPosition(), NLS.bind((String)Messages.DECORATOR_DELEGATE_WITHOUT_DECORATOR, (Object)decl.getSimpleName()));
            }
        }
    }

    @Override
    protected boolean isValidTarget(Declaration declaration) {
        return declaration instanceof FieldDeclaration || declaration instanceof ParameterDeclaration;
    }
}

